<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCashbackRulesTable extends Migration
{
    public function up()
    {
        Schema::create('cashback_rules', function (Blueprint $table) {
            $table->id();
            $table->text('title');
            $table->string('user_type')->comment('all, specific_user')->default('all')->nullable();
            $table->timestamp('start_datetime')->nullable();
            $table->timestamp('end_datetime')->nullable();
            $table->double('amount');
            $table->string('amount_type')->comment('fixed, percentage')->default('fixed')->nullable();
            $table->double('min_purchase_amount');
            $table->boolean('apply_cashback_per_item')->default(1);
            $table->boolean('status')->default(1);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('cashback_rules');
    }
}
