<?php

namespace Modules\Noticeboard\Http\Controllers;

use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Routing\Controller;
use Modules\Noticeboard\Http\Requests\NoticeTypeRequest;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardRepositoryInterface;
use Modules\Noticeboard\Repositories\Interfaces\NoticeboardTypeRepositoryInterface;

class NoticeboardTypeController extends Controller
{
    protected $noticeboardTypeRepository, $noticeboardRepository;

    public function __construct(NoticeboardTypeRepositoryInterface $noticeboardTypeRepository, NoticeboardRepositoryInterface $noticeboardRepository)
    {
        $this->noticeboardTypeRepository = $noticeboardTypeRepository;
        $this->noticeboardRepository = $noticeboardRepository;
    }

    public function index()
    {
        return view('noticeboard::type.index', [
            'types' => $this->noticeboardTypeRepository->all()
        ]);
    }

    public function store(NoticeTypeRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->noticeboardTypeRepository->create($request->validated());
        return redirect()->back();
    }

    public function update(NoticeTypeRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $this->noticeboardTypeRepository->update($request->id, $request->validated());
        return redirect()->back();
    }

    public function delete(NoticeTypeRequest $request)
    {
        if (demoCheck()) {
            return redirect()->back();
        }
        $notices = $this->noticeboardRepository->getByCondition(['type' => $request->id])->count();
        if (!$notices == 0) {
            Toastr::error(trans('frontend.Type is not empty'), trans('common.Failed'));
            return redirect()->back();
        }
        $this->noticeboardTypeRepository->deleteById($request->id);
        return redirect()->back();
    }
}
