@extends('backend.master')


@php
    $table_name = 'products';
@endphp
@section('table')
    {{ $table_name }}
@endsection
@push('styles')
    <style>
        .single_img img {
            height: 70px;
        }

        .single_img {
            margin-right: 10px;
        }

        .photo_uploader {
            font-size: 25px;
        }

    </style>
@endpush
@section('mainContent')

    @php
        $LanguageList = getLanguageList();
    @endphp

    {!! generateBreadcrumb() !!}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex mb-0">
                            <h3 class="mb-0">
                                {{ __('product.Update Product') }}
                            </h3>

                        </div>
                    </div>


                    <div class="white-box mb_30  student-details header-menu">

                        <div class="row pt-0">
                            @if (isModuleActive('FrontendMultiLang'))
                                <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3" role="tablist">
                                    @foreach ($LanguageList as $key => $language)
                                        <li class="nav-item">
                                            <a class="nav-link  @if (auth()->user()->language_code == $language->code) active @endif"
                                               href="#element{{ $language->code }}" role="tab"
                                               data-bs-toggle="tab">{{ $language->native }} </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>


                        @if (permissionCheck('store.product.update'))
                            <form action="{{ route('store.product.update') }}" method="POST" id="category-form"
                                  name="category-form" enctype="multipart/form-data">
                                @endif

                                @csrf


                                <div class="tab-content">
                                    @foreach ($LanguageList as $key => $language)
                                        <div role="tabpanel"
                                             class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                             id="element{{ $language->code }}">
                                            <div class="row">
                                                <div class="col-sm-6">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label"
                                                               for="nameInput">{{ __('common.Name') }}
                                                            <strong class="text-danger">*</strong></label>
                                                        <input name="name[{{ $language->code }}]" id="nameInput"
                                                               class="primary_input_field name {{ @$errors->has('name') ? ' is-invalid' : '' }}"
                                                               placeholder="{{ __('common.Name') }}" type="text"
                                                               value="{{ $product->getTranslation('title', $language->code) }}">

                                                        @if ($errors->has('name'))
                                                            <span class="invalid-feedback d-block mb-10" role="alert">
                                                        <strong>{{ @$errors->first('name') }}</strong>
                                                    </span>
                                                        @endif

                                                    </div>

                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-15">
                                                        <label class="primary_input_label" for="">
                                                            {{ __('common.Description') }} </label>
                                                        <textarea class="lms_summernote" id="addAbout" cols="30"
                                                                  rows="5"
                                                                  name="description[{{ $language->code }}]">{{ $product->getTranslation('description', $language->code) }}</textarea>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    @endforeach

                                </div>

                                <input type="hidden" name="id" class="product_id" value="{{ $product->id }}">


                                <div class="row mt-25">
                                    <div class="col-sm-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label"
                                                   for="productType">{{ __('product.Type') }}</label>
                                            <select class="primary_select mb-25" name="productType" id="productType">
                                                <option value="2" {{ $product->type == '2' ? 'selected' : '' }}>
                                                    {{ __('product.Physical') }}
                                                </option>

                                                <option {{ $product->type == '1' ? 'selected' : '' }} value="1">
                                                    {{ __('product.Virtual') }}
                                                </option>

                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-sm-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label"
                                                   for="status">{{ __('product.Status') }}</label>
                                            <select class="primary_select mb-25" name="status" id="status">
                                                <option value="1" {{ $product->status == '1' ? 'selected' : '' }}>
                                                    {{ __('common.Active') }}
                                                </option>

                                                <option {{ $product->status == '0' ? 'selected' : '' }} value="0">
                                                    {{ __('common.Inactive') }}
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                </div>


                                <div class="row mt-25">
                                    <div class="col-xl-6 courseBox mb-25">
                                        <label class="primary_input_label" for="author">{{ __('product.Category') }}
                                            <strong class="text-danger">*</strong>
                                        </label>
                                        <select class="primary_select edit_category_id"
                                                data-course_id="{{ @$product->id }}"
                                                name="category" id="category_id">
                                            <option
                                                data-display="{{ __('common.Select') }} {{ __('product.Category') }}"
                                                value="">{{ __('common.Select') }} {{ __('product.Category') }} </option>
                                            @php
                                                request()->replace(['category' => $product->category_id]);
                                            @endphp
                                            @foreach ($categories as $category)
                                                @if ($category->parent_id == 0)
                                                    @include('store::products._single_select_option', [
                                                        'category' => $category,
                                                        'level' => 1,
                                                    ])
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="col-xl-6 courseBox mb-25" id="edit_subCategoryDiv{{ @$product->id }}">
                                        <label class="primary_input_label"
                                               for="author">{{ __('product.Sub Category') }} </label>
                                        <select class="primary_select " name="sub_category" id="edit_subcategory_id">
                                            <option
                                                data-display="{{ __('common.Select') }} {{ __('product.Sub Category') }}"
                                                value="">{{ __('common.Select') }}
                                                {{ __('product.Sub Category') }}
                                            </option>
                                            <option value="{{ @$product->sub_category_id }}" selected>
                                                {{ @$product->subCategory->title }}</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 mb-25">
                                        <div class="checkbox_wrap d-flex align-items-center">
                                            <label for="is_free" class="switch_toggle me-2">
                                                <input type="checkbox" id="is_free" value="1"
                                                       name="is_free" {{ $product->price == 0?'checked':'' }}>
                                                <i class="slider round"></i>
                                            </label>
                                            <label
                                                class="mb-0">{{ __('product.This product is a free product') }}</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row mt-20">

                                    <div class="col-sm-4 must_price {{ $product->price == 0?'d-none':'' }}"
                                         id="price_div">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="">{{ __('product.Price') }} <strong
                                                    class="text-danger">*</strong></label>
                                            <input class="primary_input_field" name="price" placeholder="-"
                                                   id="addPrice"
                                                   type="text" value="{{ $product->price }}">
                                        </div>
                                    </div>
                                    <div class="col-lg-4 must_price {{ $product->price == 0?'d-none':'' }}">
                                        <div class="primary_input mb-15">
                                            <label class="primary_input_label"
                                                   for="discount"> {{ __('common.Discount') }}</label>
                                            <input class="primary_input_field" name="discount" id="discount"
                                                   placeholder="{{ __('common.Discount') }}" type="number" min="0"
                                                   value="{{ $product->discount?$product->discount:0}}">
                                            <span class="text-danger"
                                                  id="error_discunt">{{ $errors->first('discount')}}</span>
                                        </div>
                                    </div>
                                    <div class="col-lg-4 must_price {{ $product->price == 0?'d-none':'' }}">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label"
                                                   for="discount_type">{{ __('product.discount_type')}}</label>
                                            <select class="primary_select mb-25" name="discount_type"
                                                    id="discount_type">
                                                <option data-display="{{ __('common.Select') }}"
                                                        value="">{{ __('common.Select') }}</option>
                                                <option value="1"
                                                        @if($product->discount_type && $product->discount_type == 1) selected @endif>{{ __('common.Amount') }}</option>
                                                <option value="2"
                                                        @if($product->discount_type && $product->discount_type == 2) selected @endif>{{ __('product.Percentage') }}</option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                                <div class="row mt-20">
                                    <div class="col-sm-6">
                                        <x-upload-file
                                            name="pdf_file"
                                            type="pdf"
                                            media_id="{{isset($product)?$product->pdf_media?->media_id:''}}"
                                            label="{{ __('product.PDF Specifications') }}"
                                        />

                                    </div>


                                    <div class="col-sm-6" id="linkdiv">
                                        <div class="primary_input mb-30">
                                            <label class="primary_input_label" for="">
                                                {{ __('product.Video Link') }}</label>
                                            <input class="primary_input_field" name="link" placeholder="-" type="text"
                                                   value="{{ $product->link }}">
                                            <span class="text-danger">{{ $errors->first('link') }}</span>
                                        </div>
                                    </div>
                                </div>

                                <div class="row mt-20">

                                    <div class="col-lg-6 attribute_div" id="attribute_select_div">
                                        @include('store::products._attribute_list_select')
                                    </div>

                                    <div class="col-xl-6 courseBox mb_30" id="customer_choice_options">
                                        <label class="primary_input_label"
                                               for="author">{{ __('product.Attribute Value') }}
                                        </label>
                                        <select class="primary_select" name="choice_options" id="choice_options"
                                            {{ $errors->has('choice_options') ? 'autofocus' : '' }}>
                                            <option
                                                data-display="{{ __('common.Select') }} {{ __('product.Attribute Value') }}  "
                                                value="">{{ __('common.Select') }} {{ __('product.Attribute Value') }}
                                            </option>
                                        </select>
                                    </div>

                                </div>


                                <div class="row mt-20" id="valueTable">

                                </div>
                                @if (count($product->variations) > 0)
                                    <div class="row mt-20">
                                        <div class="col-lg-12">
                                            <strong>{{ __('product.Attribute Value') }} </strong> <span
                                                class="text-danger"></span>
                                            <div class="QA_section2 QA_section_heading_custom check_box_table">
                                                <div class="QA_table mb_15">
                                                    <div class="table-responsive">
                                                        <table class="table create_table">
                                                            <tr>
                                                                <th>Attribute Name</th>
                                                                <th>Value</th>
                                                                <th>Inventory</th>
                                                                <th>price</th>
                                                            </tr>
                                                            <tbody>

                                                            @foreach ($product->variations as $key => $items)
                                                                <tr class="variant_edit_row_lists">
                                                                    <td class="ps-0 pb-0 border-0">

                                                                        <input class="placeholder_input"
                                                                               value="{{ $items->attribute->title }}"
                                                                               placeholder="-" name="edit_variant[]"
                                                                               type="text" readonly>
                                                                    </td>

                                                                    <td class="ps-0 pb-0 border-0">

                                                                        <input class="placeholder_input"
                                                                               value="{{ $items->attributevalue->value }}"
                                                                               placeholder="-"
                                                                               name="edit_variant_values[]"
                                                                               type="text" readonly>
                                                                    </td>
                                                                    <td class="ps-0 pb-0 border-0">
                                                                        <input type="text"
                                                                               class="form-control primary_input_field"
                                                                               placeholder="QTY" name="edit_qty[]"
                                                                               value="{{ $items->product_stock }}">
                                                                    </td>
                                                                    <td class="ps-0 pb-0 border-0">
                                                                        <input type="text"
                                                                               class="form-control primary_input_field"
                                                                               placeholder="PRICE"
                                                                               name="edit_Value_price[]"
                                                                               value="{{ $items->product_price }}">

                                                                    </td>

                                                                    <td><input type="hidden" class="d-none"
                                                                               name="value_id[]"
                                                                               value="{{ $items->id }}">
                                                                    </td>
                                                                    <td><input type="hidden" class="d-none"
                                                                               name="attribute_id[]"
                                                                               value="{{ $items->attribute_id }}"></td>

                                                                    <td class="ps-0 pb-0 pe-0 remove_edit border-0">

                                                                        <div class="items_min_icon "><i
                                                                                class="ti-trash"></i>
                                                                        </div>

                                                                    </td>

                                                                </tr>
                                                            @endforeach

                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif


                                <div class="row mt-20">
                                    <div class="col-sm-6">
                                        <div class="primary_input">
                                            <label class="primary_input_label" for="author">{{ __('product.Author') }}
                                            </label>
                                            <select class="primary_select" name="product_author" id="product_author"
                                                {{ $errors->has('product_author') ? 'autofocus' : '' }}>
                                                <option
                                                    data-display="{{ __('common.Select') }} {{ __('product.Author') }}"
                                                    value="">{{ __('common.Select') }}
                                                    {{ __('product.Author') }} </option>

                                                @foreach ($authors as $author)
                                                    <option value="{{ $author->id }}"
                                                        {{ $author->id == $product->author_id ? 'selected' : '' }}>
                                                        {{ @$author->title }} </option>
                                                @endforeach


                                            </select>

                                        </div>
                                    </div>

                                    <div class="col-sm-6">
                                        <div class="primary_input">
                                            <label class="primary_input_label" for="author">{{ __('product.Brand') }}
                                            </label>
                                            <select class="primary_select" name="product_brand" id="product_brand"
                                                {{ $errors->has('product_brand') ? 'autofocus' : '' }}>
                                                <option
                                                    data-display="{{ __('common.Select') }} {{ __('product.Brand') }}"
                                                    value="">{{ __('common.Select') }}
                                                    {{ __('product.Brand') }} </option>
                                                @foreach ($brands as $brand)
                                                    <option value="{{ $brand->id }}"
                                                        {{ $brand->id == $product->brand_id ? 'selected' : '' }}>
                                                        {{ @$brand->name }} </option>
                                                @endforeach

                                            </select>

                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-20">
                                    @php
                                        $images =  $product->product_image;
                                          $ids =[];
                                          foreach ($images as $img){
                                           if ($img->thumbnail_media){
                                              $ids[] = $img->thumbnail_media->media_id;
                                           }
                                          }
                                    @endphp
                                    <div class="photo_uploader_lists col-lg-12">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <x-upload-file
                                                    name="thumbimage[]"
                                                    type="image"
                                                    multiple="true"
                                                    media_id="{{implode(',',$ids)}}"
                                                    label="{{ __('product.Product Thumbnails') }}"
                                                />


                                            </div>
                                        </div>

                                    </div>

                                    <div class="col-xl-6" id="soft_file">
                                        <div class=" mb-35">
                                            <x-upload-file
                                                type="pdf"
                                                required="true"
                                                name="soft_file"
                                                media_id="{{isset($product)?$product->soft_file_media?->media_id:''}}"

                                                label="{{ _trans('product.Soft File') }}"
                                            />
                                        </div>
                                    </div>

                                </div>

                                <div class="row mt-20">
                                    <div class="col-sm-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label"
                                                   for="readAble">{{ __('product.Readable') }}</label>
                                            <select class="primary_select mb-25" name="readAble" id="readAble">
                                                <option value="1" {{ $product->is_readable == '1' ? 'selected' : '' }}>
                                                    {{ __('product.Yes') }}
                                                </option>
                                                <option {{ $product->is_readable == '0' ? 'selected' : '' }} value="0">
                                                    {{ __('product.No') }}
                                                </option>


                                            </select>
                                        </div>
                                    </div>
                                </div>


                                <div class="row mt-20" id="editDiscountDiv">
                                    <div class="col-sm-3">
                                        <div class="checkbox_wrap d-flex align-items-center mt-40">
                                            <label for="edit_course_3" class="switch_toggle me-2">
                                                <input type="checkbox" class="edit_course_3" id="edit_course_3"
                                                       value="1"
                                                       name="stock_manage"
                                                       @if ($product->stock_manage == 1) checked @endif>
                                                <i class="slider round"></i>
                                            </label>
                                            <label class="mb-0">{{ __('product.Stock Manage') }}</label>
                                        </div>
                                    </div>
                                    @php
                                        if ($product->stock_manage == 1) {
                                            $d_price = 'block';
                                        } else {
                                            $d_price = 'none';
                                        }
                                    @endphp

                                    <div class="col-sm-3" id="edit_inventoryQntyDiv" style="display: {{ $d_price }}">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="">{{ __('product.Stock Quantity') }}
                                            </label>
                                            <input class="primary_input_field" name="stock_quantity" placeholder="-"
                                                   id="stock_quantity" type="text"
                                                   value="{{ $product->stock_quantity }}">
                                        </div>
                                    </div>


                                </div>
                                <div class="col-lg-12 mt-20">
                                    <div class="tab-content">
                                        @foreach ($LanguageList as $key => $language)
                                            <div role="tabpanel"
                                                 class="tab-pane fade @if (auth()->user()->language_code == $language->code) show active @endif  "
                                                 id="element{{ $language->code }}">
                                                <div class="row">
                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label" for="">
                                                                {{ _trans('common.Specification') }} </label>
                                                            <textarea class="lms_summernote" cols="30" rows="5"
                                                                      name="specification[{{ $language->code }}]">{{ $product->getTranslation('specification', $language->code) }}</textarea>
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-15">
                                                            <label class="primary_input_label" for="">
                                                                {{ _trans('common.Faq') }} </label>
                                                            <textarea class="lms_summernote" id="addAbout" cols="30"
                                                                      rows="5"
                                                                      name="faq[{{ $language->code }}]">{{ $product->getTranslation('faq', $language->code) }}</textarea>
                                                        </div>
                                                    </div>

                                                </div>
                                            </div>
                                        @endforeach

                                    </div>
                                </div>


                                @php
                                    $tooltip = '';
                                    if (permissionCheck('store.attribute.store')) {
                                        $tooltip = '';
                                    } else {
                                        $tooltip = trans('courses.You have no permission to add');
                                    }
                                @endphp
                                <div class="col-lg-12 text-center">
                                    <div class="d-flex justify-content-center pt_20">
                                        <button type="submit" class="primary-btn semi_large fix-gr-bg"
                                                data-bs-toggle="tooltip"
                                                title="{{ @$tooltip }}" id="save_button_parent">
                                            <i class=" fa fa-check "></i>

                                            {{ __('common.Update') }}

                                        </button>


                                    </div>
                                </div>


                            </form>
                    </div>

                </div>

            </div>
        </div>
    </section>

@endsection

@push('scripts')
    <script src="{{ asset('/') }}/Modules/Store/Resources/assets/js/product.js"></script>
    <script>
        (function ($) {
            "use strict";

            $(document).on('change', '.upload_img_for_product', function (event) {
                let upload_div = $(this).data('upload_div');
                let count = $(this).data('count');
                uploadImage($(this)[0], upload_div, count);
            });

            function uploadImage(data, divId, count) {
                if (data.files) {
                    if (data.files.length > 6) {
                        toastr.error("{{__('defaultTheme.maximum_6_image_can_upload')}}", "{{__('common.error')}}");
                        data.value = '';
                    } else {
                        $.each(data.files, function (key, value) {
                            $(divId).empty();
                            $(count).text(data.files.length + '/4');
                            var reader = new FileReader();
                            reader.onload = function (e) {
                                $(divId).append(
                                    `<div class="single_img">
                                <img src="` + e.target.result + `" alt="">
                            </div>`);
                            };
                            reader.readAsDataURL(value);
                        });
                    }
                }
            }
        })(jQuery);

    </script>
@endpush
