<form method="POST" enctype="multipart/form-data" action="{{route('store.shiprate.store')}}">
    @csrf
    <div class="white_box p-15 box_shadow_white mb-20">
        <div class="box_header common_table_header">
            <div class="main-title d-md-flex">
                <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px">{{ _trans('store.add_new_shipping_rate') }}</h3>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for=""> {{__("common.Name")}} <span class="text-danger">*</span></label>
                    <input class="primary_input_field" name="method_name" id="method_name"
                           placeholder=" {{__("common.Name")}}" type="text" value="{{old('method_name')}}">
                    <span class="text-danger" id="error_method_name"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for="carrier_id">{{ _trans('store.carrier') }}</label>
                    <select class="primary_select mb-15" id="carrier_id" name="carrier_id">
                        @foreach($data['carriers'] as $carrier)
                            <option
                                {{old('carrier_id') == $carrier->id ? 'selected' :''}} value="{{$carrier->id}}">{{$carrier->name}}</option>
                        @endforeach
                    </select>
                    <span class="text-danger" id="error_carrier_id"></span>
                </div>
            </div>

            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for=""> {{_trans("store.shipment_time")}} <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="shipment_time" id="shipment_time"
                           placeholder="{{_trans("store.ex: 3-5 days or 6-12 hrs")}}" type="text"
                           value="{{old('shipment_time')}}">
                    <span class="text-danger" id="error_shipment_time"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <label class="primary_input_label" for="">{{_trans('store.cost')}} {{_trans('store.based_on')}} <span
                        class="text-danger">*</span></label>
                <ul class="permission_list sms_list">

                    <li>
                        <label class="primary_checkbox d-flex mr-12 ">
                            <input checked name="cost_based_on" class="cost_based_on" type="radio" id="cost_based_on"
                                   value="Flat">
                            <span class="checkmark"></span>
                        </label>
                        <p>{{_trans('store.flat')}}</p>
                    </li>
                </ul>
                <span class="text-danger" id="error_cost_based_on"></span>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for=""> {{_trans("store.minimum_shopping_amount")}}
                        ({{_trans('store.without_shipping_cost')}}) <span class="required_mark">*</span></label>
                    <input class="primary_input_field" name="minimum_shopping" id="minimum_shopping"
                           placeholder="{{_trans("store.minimum_shopping_amount")}}" type="number" min="0"
                           value="{{old('minimum_shopping')}}">
                    <span class="text-danger" id="error_minimum_shopping"></span>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="primary_input mb-15">
                    <label class="primary_input_label" for=""> {{_trans("store.cost")}} <span
                            class="cost_help_label required_mark_theme"></span> <span
                            class="text-danger">*</span></label>
                    <input class="primary_input_field" name="cost" id="cost" placeholder="{{_trans("store.cost")}}"
                           type="number" min="0" value="{{old('cost')}}">
                    <span class="text-danger" id="error_cost"></span>
                </div>
            </div>

            <div class="col-lg-12 text-center">

                <div class="d-flex justify-content-center pt_20">
                    <button type="submit" class="primary-btn semi_large update_btn fix-gr-bg"
                            id="save_button_parent">
                        <i class=" fa fa-check "></i>

                        {{__("common.save")}}

                    </button>
                </div>

            </div>
        </div>
    </div>
</form>
