<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\RolePermission\Entities\Permission;

class AddSubscriptionMenuPemission extends Migration
{
    public function up()
    {
        $routes = [
            'subscription.faq',
            'subscription.plan',
            'subscription.planFeature',
            'subscription.setting',
            'subscription.faq.index',
            'subscription.plan.index',
            'subscription.planFeature.index',
            'subscription.setting.index'
        ];
        Permission::whereIn('route', $routes)->delete();

        $menus = [
            [
                'name' => 'subscription',
                'route' => 'subscription',
                'parent_route' => null,
                'type' => 1,
                'module' => 'Subscription'
            ], [
                'name' => 'Plan',
                'route' => 'subscription.plan.index',
                'parent_route' => 'subscription',
                'type' => 2,
                'module' => 'Subscription'
            ], [
                'name' => 'Feature',
                'route' => 'subscription.planFeature.index',
                'parent_route' => 'subscription',
                'type' => 2,
                'module' => 'Subscription'
            ], [
                'name' => 'FAQ',
                'route' => 'subscription.faq.index',
                'parent_route' => 'subscription',
                'type' => 2,
                'module' => 'Subscription'
            ], [
                'name' => 'Setting',
                'route' => 'subscription.setting.index',
                'parent_route' => 'subscription',
                'type' => 2,
                'module' => 'Subscription'
            ],


            [
                'name' => 'FAQ Add',
                'route' => 'subscription.faq.store',
                'parent_route' => 'subscription.faq',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'FAQ Edit',
                'route' => 'subscription.faq.update',
                'parent_route' => 'subscription.faq',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'FAQ Delete',
                'route' => 'subscription.faq.destroy',
                'parent_route' => 'subscription.faq',
                'type' => 3,
                'module' => 'Subscription'
            ],

            [
                'name' => 'Plan Add',
                'route' => 'subscription.plan.store',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Plan Edit',
                'route' => 'subscription.plan.update',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Plan Delete',
                'route' => 'subscription.plan.destroy',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Course Assign',
                'route' => 'assignCourseToPlan',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ],
            [
                'name' => 'Plan Feature Add',
                'route' => 'subscription.planFeature.store',
                'parent_route' => 'subscription.planFeature',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Plan Feature Edit',
                'route' => 'subscription.planFeature.update',
                'parent_route' => 'subscription.planFeature',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Plan Feature Delete',
                'route' => 'subscription.planFeature.destroy',
                'parent_route' => 'subscription.planFeature',
                'type' => 3,
                'module' => 'Subscription'
            ],

            [
                'name' => 'Submit',
                'route' => 'subscription.setting.store',
                'parent_route' => 'subscription.setting',
                'type' => 3,
                'module' => 'Subscription'
            ],

            [
                'name' => 'Plan Change Order',
                'route' => 'changePlanPosition',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Plan Feature Order',
                'route' => 'changePlanFeaturePosition',
                'parent_route' => 'subscription.planFeature',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Subscription FQA Order',
                'route' => 'changeFaqPosition',
                'parent_route' => 'subscription.faq',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Change Plan Popular Status',
                'route' => 'changePlanPopular',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ], [
                'name' => 'Assign courses',
                'route' => 'subscription.assignCourseToPlan',
                'parent_route' => 'subscription.plan',
                'type' => 3,
                'module' => 'Subscription'
            ],
            [
                'name' => 'Subscription List',
                'route' => 'subscription.enroll-list',
                'parent_route' => 'subscription',
                'type' => 2,
                'module' => 'Subscription'
            ],


        ];
        permissionUpdateOrCreate($menus);

        $menu = Permission::where('route', 'subscription.planFeature')->first();
        if ($menu) {
            $menu->not_theme = 'tvt';
            $menu->save();
        }
    }

    public function down()
    {
        //
    }
}
