<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Modules\SupportTicket\Entities\TicketCategory;

class ModifySupportTicketCategoryTable extends Migration
{
    public function up()
    {
        Schema::table('support_ticket_category', function (Blueprint $table) {
            if (!Schema::hasColumn("support_ticket_category", 'is_system')) {
                $table->boolean('is_system')->default(false);
            }
            if (!Schema::hasColumn("support_ticket_category", 'slug')) {
                $table->string('slug')->nullable();
            }
        });

        $cat = new TicketCategory();
        $cat->name = 'Course';
        $cat->slug = 'course';
        $cat->is_system = true;
        $cat->save();
    }

    public function down()
    {
        Schema::table('support_ticket_category', function (Blueprint $table) {
            if (Schema::hasColumn("support_ticket_category", 'is_system')) {
                $table->dropColumn('is_system');
            }
            if (Schema::hasColumn("support_ticket_category", 'slug')) {
                $table->dropColumn('slug');
            }
        });
    }
}
