<?php

namespace Modules\Survey\Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Model;
use Modules\Survey\Entities\Survey;
use Modules\Survey\Entities\SurveyGroup;
use Modules\Survey\Entities\SurveyQuestion;
use Modules\Survey\Entities\SurveyQuestionBank;

class SurveyDatabaseSeeder extends Seeder
{

    public function run()
    {
        Model::unguard();

        $groups = [
            [
                'title' => 'Group 1',
            ], [
                'title' => 'Group 2',
            ], [
                'title' => 'Group 3',
            ],
        ];
        SurveyGroup::insert($groups);


        $questions = [
            [
                'type' => 'textarea',
                'question' => 'This is a test question 1',
                'group_id' => '1',
                'category_id' => '1',
            ],
            [
                'type' => 'textarea',
                'question' => 'This is a test question 2',
                'group_id' => '1',
                'category_id' => '1',
            ],
            [
                'type' => 'textarea',
                'question' => 'This is a test question 3',
                'group_id' => '1',
                'category_id' => '1',
            ]
        ];
        SurveyQuestionBank::insert($questions);

        $survives = [
            [
                'title' => 'Test Survey',
                'publish_date' => now(),
                'publish_time' => '12:00:00pm',
                'created_by' => 1,
                'is_published' => 1,
                'category_id' => 1,
                'survey_type' => 1,
                'audience' => 1,
                'position_audience' => 1,
                'deadline_date' => now()->addMonths(1),
                'deadline_time' => '12:00:00pm',
            ],
        ];

        Survey::insert($survives);
    }
}
