<?php

namespace Modules\Survey\Http\Controllers;

use ReflectionClass;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Contracts\Support\Renderable;
use Modules\Survey\Entities\SurveyQuestionSet;

class QuestionSetController extends Controller
{
    public function index()
    {
        $sets = SurveyQuestionSet::get();
        return view('survey::set.index', compact('sets'));
    }


    public function create()
    {
        return view('survey::create');
    }

    public function store(Request $request)
    {
        $rules = [
            'name' => 'required',
            'answer_type' => 'required',
        ];

        $request->validate($rules, validationMessage($rules));
        try {
            $set = new SurveyQuestionSet();
            $set->name = $request->name;
            $set->answer_type = $request->answer_type;
            $set->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->back();
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }

    public function ajaxAnswerSetFromAnswerType(Request $request)
    {
        try {

            $questionSets = SurveyQuestionSet::where('answer_type', $request->type)->where('status', 1)->get();

            return response()->json([$questionSets]);
        } catch (Exception $e) {
            return response()->json("", 404);
        }
    }

    public function show($id)
    {
        $sets = SurveyQuestionSet::get();
        $edit = SurveyQuestionSet::find($id);
        return view('survey::set.index', compact('sets', 'edit'));
    }


    public function edit($id)
    {
        $sets = SurveyQuestionSet::get();
        $edit = SurveyQuestionSet::find($id);
        return view('survey::set.index', compact('sets', 'edit'));
    }


    public function update(Request $request)
    {
        $rules = [
            'id' => 'required',
            'name' => 'required',
            'answer_type' => 'required',
        ];

        $request->validate($rules, validationMessage($rules));
        try {
            $set = SurveyQuestionSet::find($request->id);
            $set->name = $request->name;
            $set->answer_type = $request->answer_type;
            $set->save();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('survey.set_list');
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }


    public function destroy($id)
    {
        try {
            $set = SurveyQuestionSet::find($id);
            $set->delete();
            Toastr::success(trans('common.Operation successful'), trans('common.Success'));
            return redirect()->route('survey.set_list');
        } catch (\Throwable $th) {
            Toastr::error(trans('common.Operation failed'), trans('common.Failed'));
            return redirect()->back();
        }
    }
}
