@extends('backend.master')
@php
    $table_name='country_wish_taxes';
@endphp
@section('table')
    {{$table_name}}
@endsection
@section('mainContent')

    {{generateBreadcrumb()}}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="row">
                <div class="col-lg-3">
                    <div class="white-box mb_30 ">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0"> @if(!isset($edit))
                                        {{__('tax.Add New Tax') }}
                                    @else
                                        {{__('tax.Update Tax')}}
                                    @endif</h3>
                                @if(isset($edit))
                                    @if (permissionCheck('tax.setting.index'))
                                        <a href="{{route('tax.country-wish-tax.index')}}"
                                           class="primary-btn small fix-gr-bg ms-4" style="line-height: 25px;"
                                           title="{{__('courses.Add New')}}">+</a>
                                    @endif
                                @endif
                            </div>
                        </div>
                        @if (isset($edit))
                            @if (permissionCheck('tax.setting.index'))
                                <form action="{{route('tax.country-wish-tax.update')}}" method="POST" id="category-form"
                                      name="category-form" enctype="multipart/form-data">
                                    <input type="hidden" name="id"
                                           value="{{$edit->id}}">
                                    @endif
                                    @else
                                        @if (permissionCheck('tax.setting.index'))
                                            <form action="{{route('tax.country-wish-tax.store') }}" method="POST"
                                                  id="category-form" name="category-form" enctype="multipart/form-data">
                                                @endif
                                                @endif
                                                @csrf

                                                <div class="row">


                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="country_id">{{ __('tax.Country') }} <strong
                                                                    class="required_mark">*</strong></label>
                                                            <select class="primary_select mb-25" name="country_id"
                                                                    id="country_id">
                                                                <option
                                                                    value="">{{__('common.Select')}} {{__('tax.Country')}}</option>
                                                                @foreach($countries as $country)
                                                                    <option
                                                                        value="{{$country->id}}"
                                                                        {{isset($edit)?($edit->country_id==$country->id?'selected':old('country_id')):old('country_id')}}
                                                                    >{{$country->name}}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label "
                                                                   for="nameInput">{{ __('tax.Tax') }} (%) <strong
                                                                    class="required_mark">*</strong></label>
                                                            <input name="tax" id="tax" required
                                                                   class="primary_input_field name {{ @$errors->has('tax') ? ' is-invalid' : '' }}"
                                                                   placeholder="{{ __('tax.Tax') }}" type="number"
                                                                   min="0"
                                                                   max="100"
                                                                   step="1"
                                                                   value="{{isset($edit)?$edit->tax:old('tax')}}" {{$errors->has('tax') ? 'autofocus' : ''}}>
                                                            @if ($errors->has('tax'))
                                                                <span class="invalid-feedback d-block mb-10"
                                                                      role="alert">
                                                                <strong>{{ @$errors->first('tax') }}</strong>
                                                            </span>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-12">
                                                        <div class="primary_input mb-25">
                                                            <label class="primary_input_label"
                                                                   for="status">{{ __('courses.Status') }} <strong
                                                                    class="required_mark">*</strong></label>
                                                            <select class="primary_select mb-25" name="status"
                                                                    id="status"
                                                            >
                                                                <option
                                                                    value="1" {{isset($edit)?($edit->status==1?'selected':''):''}}>{{__('common.Active') }}</option>
                                                                <option
                                                                    value="0" {{isset($edit)?($edit->status==0?'selected':''):''}}>{{__('common.Inactive') }}</option>
                                                            </select>
                                                        </div>
                                                    </div>


                                                    @php
                                                        $tooltip = "";
                                                        if(permissionCheck('tax.setting.index')){
                                                              $tooltip = "";
                                                          }else{
                                                              $tooltip = trans("courses.You have no permission to add");
                                                          }
                                                    @endphp
                                                    <div class="col-lg-12 text-center">
                                                        <div class="d-flex justify-content-center pt_20">
                                                            <button type="submit"
                                                                    class="primary-btn semi_large fix-gr-bg"
                                                                    data-bs-toggle="tooltip" title="{{@$tooltip}}"
                                                                    id="save_button_parent">
                                                                <i class="ti-check"></i>
                                                                @if(!isset($edit))
                                                                    {{ __('common.Save') }}
                                                                @else
                                                                    {{ __('common.Update') }}
                                                                @endif
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>

                                            </form>
                    </div>
                </div>
                <div class="col-lg-9">
                    <div class="white-box">
                        <div class="box_header common_table_header">
                            <div class="main-title d-flex flex-wrap mb-0">
                                <h3 class="mb-0" id="page_title">{{__('tax.Country Wish Tax List')}}</h3>
                            </div>
                        </div>
                        <div class="  QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('tax.Country') }}</th>
                                            <th scope="col">{{ __('tax.Tax') }}</th>
                                            <th scope="col">{{ __('common.Status') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($taxs as $key => $tax)
                                            <tr>
                                                <td>{{++$key }}</td>
                                                <td>{{$tax->country->name }}</td>
                                                <td>{{translatedNumber($tax->tax) }}%</td>

                                                <td class="nowrap">
                                                    <label class="switch_toggle">
                                                        <input type="checkbox"
                                                               class="  status_enable_disable  "
                                                               @if (@$tax->status == 1) checked
                                                               @endif value="{{@$tax->id }}">
                                                        <i class="slider round"></i>
                                                    </label>
                                                </td>

                                                <td>
                                                    <!-- shortby  -->
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu1{{@$tax->id}}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu1{{@$tax->id}}">
                                                            @if (permissionCheck('tax.setting.index'))
                                                                <a class="dropdown-item edit_brand"
                                                                   href="{{route('tax.country-wish-tax.edit',$tax->id)}}">{{__('common.Edit')}}</a>
                                                            @endif
                                                            @if (permissionCheck('tax.setting.index'))
                                                                <a onclick="confirm_modal('{{route('tax.country-wish-tax.delete', $tax->id)}}');"
                                                                   class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!-- shortby  -->
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    @include('backend.partials.delete_modal')
@endsection
@push('scripts')
    <script type="application/javascript">

        (function ($) {
            "use strict";
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2]);

            $('#lms_table').DataTable(dataTableOptions);

        })(jQuery);
    </script>
@endpush
