@extends('backend.master')
@push('styles')
    <link rel="stylesheet" href="{{ asset('public/backend/css/daterangepicker.css') }}">
@endpush

@php
    $url = route('admin.upcoming_courses.pre_booking.datatable',$id)
@endphp


@section('mainContent')
    {!! generateBreadcrumb() !!}
    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row justify-content-center mt-50">
                <div class="col-lg-12">
                    <div class="white_box mb_30">
                        <div class="white_box_tittle list_header">
                            <h4>{{__('courses.Advanced Filter')}} </h4>
                        </div>
                        <form action="#" method="POST">
                            @csrf
                            <div class="row">

                                <div class="col-3 mt-30">
                                    <div class="primary_input mb-15 date_range">
                                        <div class="primary_datepicker_input filter">
                                            <label class="primary_input_label" for="">{{__('common.Date')}}</label>
                                            <div class="g-0  input-right-icon">
                                                <div class="col">
                                                    <div class="">
                                                        <input placeholder="{{__('common.Date')}}" readonly
                                                               class="primary_input_field date_range_input" type="text"
                                                               name="date_range_filter" value="">
                                                    </div>
                                                </div>
                                                <button class="" type="button">
                                                    <i class="fa fa-refresh" id="reset-date-filter"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="search_course_btn text-end">
                                        <button type="button"
                                                class="primary-btn radius_30px   fix-gr-bg reset_btn">
                                            <i class="ti ti-search"></i>
                                            {{__('common.Reset')}} </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-12">
                    <div class="box_header common_table_header">
                        <div class="main-title d-md-flex">
                            <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"
                                id="page_title">{{$course->title}} {{__('courses.Prebooking')}}</h3>
                        </div>

                    </div>
                </div>

                <div class="col-lg-12">
                    <div class="QA_section QA_section_heading_custom check_box_table">
                        <div class="QA_table">
                            <!-- table-responsive -->
                            <div class="">
                                <table id="lms_table" class="table classList">
                                    <thead>
                                    <tr>
                                        <th scope="col"> {{__('common.SL')}}</th>
                                        <th scope="col">{{__('common.Name')}}</th>
                                        <th scope="col">{{__('common.Email')}}</th>
                                        <th scope="col">{{__('courses.Booking Date')}}</th>
                                        <th scope="col">{{__('courses.Booking Amount')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    </div>
                </div>


            </div>


        </div>
    </section>
@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/daterangepicker.min.js')}}"></script>

    <script>
        (function ($) {
            "use strict";
            dataTableOptions.serverSide = true
            dataTableOptions.processing = true
            dataTableOptions.ajax = {
                url: '{!! $url !!}',
                data: function (d) {
                    d.f_date = $('.date_range_input').val()

                }
            };
            dataTableOptions.columns = [
                {data: 'DT_RowIndex', name: 'id'},
                {
                    data: 'name', name: 'user.name'
                },
                {
                    data: 'email', name: 'user.email'
                },
                {
                    data: 'created_at', name: 'created_at'
                },

                {
                    data: 'payments', name: 'payments'
                },

            ];
            dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4]);

            let table = $('.classList').DataTable(dataTableOptions);


            $(document).on('click', '.reset_btn', function (event) {
                event.preventDefault();
                $('.date_range_input').val('');
                resetAfterChange();
            });

            var selector = ".date_range_input"
            $(selector).on('apply.daterangepicker', function (ev, picker) {
                $(this).val(picker.startDate.format('MM/DD/YYYY') + ' - ' + picker.endDate.format('MM/DD/YYYY'));
                resetAfterChange();
            });

            $(selector).daterangepicker({
                autoUpdateInput: false,
                locale: {
                    cancelLabel: 'Clear'
                },
                opens: rtl == "rtl" ? "left" : "right",
                ranges: {
                    'Today': [moment(), moment()],
                    'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                    'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                    'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                    'This Month': [moment().startOf('month'), moment().endOf('month')],
                    'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                    'This Year': [moment().startOf('year'), moment().endOf('year')],
                    'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')],
                }


            }, function (start, end, label) {

            });

            function resetAfterChange() {
                table.ajax.reload();
            }
        })(jQuery);

    </script>
@endpush
