<?php


use Illuminate\Support\Facades\Route;

Route::prefix('admin/upcoming-courses')->name('admin.upcoming_courses.')->group(function () {
    Route::get('/', 'UpcomingCourseController@index')->name('index');
    Route::get('/datatable', 'UpcomingCourseController@datatable')->name('datatable');
    Route::get('/followers/{id}', 'UpcomingCourseController@followers')->name('followers');
    Route::get('/followers/datatable/{id}', 'UpcomingCourseController@followersDatatable')->name('followers.datatable');
    Route::get('/pre-booking/{id}', 'UpcomingCourseController@prebooking')->name('pre_booking');
    Route::get('/pre-booking/datatable/{id}', 'UpcomingCourseController@prebookingDatatable')->name('pre_booking.datatable');
    Route::get('/publish/{id}', 'UpcomingCourseController@publish')->name('publish');

});
Route::get('/upcoming-courses/following/{id}', 'UpcomingCourseController@following')->name('upcoming_courses.following');
Route::get('/upcoming-courses/un-follow/{id}', 'UpcomingCourseController@unfollow')->name('upcoming_courses.unfollow');

Route::get('/upcoming-courses/prebooking/{id}', 'PrebookingController@prebooking')->name('upcoming_courses.prebooking');
Route::post('/upcoming-courses/prebooking/submit', 'PrebookingController@bookingSubmit')->name('upcoming_courses.prebooking.submit')->middleware('demo');
Route::get('paypalBookingSuccess', 'PrebookingController@paypalSuccess')->name('paypalBookingSuccess');
Route::get('paypalBookingFailed', 'PrebookingController@paypalFailed')->name('paypalBookingFailed');

Route::get('/upcoming-courses', 'UpcomingCourseController@homeIndex')->name('upcoming_courses.index');

Route::get('/my-following-upcoming-courses', 'StudentUpcomingCourseController@followingCourses')->name('upcoming_courses.my_following');
Route::get('/my-booking-upcoming-courses', 'StudentUpcomingCourseController@bookingCourses')->name('upcoming_courses.my_booking');
