<?php

namespace Modules\Appointment\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\Appointment\Repositories\Eloquents\ReviewRepository;
use Modules\Appointment\Repositories\Eloquents\BookingRepository;
use Modules\Appointment\Repositories\Eloquents\FrontendRepository;
use Modules\Appointment\Repositories\Eloquents\ScheduleRepository;
use Modules\Appointment\Repositories\Eloquents\TimeSlotRepository;
use Modules\Appointment\Repositories\Eloquents\InstructorRepository;
use Modules\Appointment\Repositories\Eloquents\AppointmentRepository;
use Modules\Appointment\Repositories\Eloquents\PageBuilderRepository;
use Modules\Appointment\Repositories\Eloquents\MyAppointmentRepository;
use Modules\Appointment\Repositories\Eloquents\PostRequestRepository;
use Modules\Appointment\Repositories\Eloquents\SettingsRepository;
use Modules\Appointment\Repositories\Interfaces\ReviewRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\BookingRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\FrontendRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\ScheduleRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\TimeSlotRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\InstructorRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\AppointmentRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\PageBuilderRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\MyAppointmentRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\PostRequestRepositoryInterface;
use Modules\Appointment\Repositories\Interfaces\SettingsRepositoryInterface;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        //
        $this->app->bind(AppointmentRepositoryInterface::class, AppointmentRepository::class);
        $this->app->bind(InstructorRepositoryInterface::class, InstructorRepository::class);
        $this->app->bind(FrontendRepositoryInterface::class, FrontendRepository::class);
        $this->app->bind(PageBuilderRepositoryInterface::class, PageBuilderRepository::class);
        $this->app->bind(ReviewRepositoryInterface::class, ReviewRepository::class);
        $this->app->bind(TimeSlotRepositoryInterface::class, TimeSlotRepository::class);
        $this->app->bind(ScheduleRepositoryInterface::class, ScheduleRepository::class);
        $this->app->bind(BookingRepositoryInterface::class, BookingRepository::class);
        $this->app->bind(MyAppointmentRepositoryInterface::class, MyAppointmentRepository::class);
        $this->app->bind(SettingsRepositoryInterface::class, SettingsRepository::class);
        $this->app->bind(PostRequestRepositoryInterface::class, PostRequestRepository::class);
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function boot()
    {
        //
    }
}
