@extends('backend.master')
@php
    $table_name='coupons';
@endphp
@section('table')
    {{$table_name}}
@stop
@section('mainContent')

    {{generateBreadcrumb()}}

    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">
            <div class="white-box">
                <div class="row">

                    <div class="col-lg-12 ">
                        <div class="main-title d-md-flex mb-5 mb-md-0 justify-content-md-between">
                            <h3 class="mb-3 mr-30 mb_xs_15px mb_sm_20px"
                                id="page_title">{{__('assignment.Assignment List')}}</h3>
                            <ul class="d-flex">
                                <li>
                                    <a class="primary-btn radius_30px fix-gr-bg" href="{{route('assignment_add')}}">
                                        <i class="ti-plus"></i>{{__('assignment.Add')}}</a>
                                </li>
                            </ul>
                        </div>

                        <div class="QA_section QA_section_heading_custom check_box_table">
                            <div class="QA_table ">
                                <!-- table-responsive -->
                                <div class="">
                                    <table id="lms_table" class="table Crm_table_active3">
                                        <thead>
                                        <tr>
                                            <th scope="col">{{ __('common.SL') }}</th>
                                            <th scope="col">{{ __('coupons.Title') }}</th>
                                            <th scope="col">{{ __('courses.Course') }}</th>
                                            <th scope="col">{{ __('assignment.Marks') }}</th>
                                            <th scope="col">{{ __('assignment.Min Percentage') }}(%)</th>
                                            <th scope="col">{{ __('assignment.Submit Date') }}</th>
                                            <th scope="col">{{ __('common.Action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach ($assignments as $key => $assignment)
                                            <tr>
                                                <td>
                                                    {{translatedNumber($key+1)}}
                                                </td>
                                                <td>
                                                    {{@$assignment->title}}
                                                </td>
                                                <td>
                                                    {{@$assignment->course->title}}
                                                </td>
                                                <td>
                                                    {{translatedNumber($assignment->marks)}}
                                                </td>
                                                <td>
                                                    {{translatedNumber($assignment->min_parcentage)}}
                                                </td>
                                                <td>
                                                    {{showDate(@$assignment->last_date_submission)}}
                                                </td>
                                                <td>
                                                    <div class="dropdown CRM_dropdown">
                                                        <button class="btn btn-secondary dropdown-toggle" type="button"
                                                                id="dropdownMenu2{{@$assignment->id }}"
                                                                data-bs-toggle="dropdown"
                                                                aria-haspopup="true"
                                                                aria-expanded="false">
                                                            {{ __('common.Select') }}
                                                        </button>
                                                        <div class="dropdown-menu dropdown-menu-right"
                                                             aria-labelledby="dropdownMenu2{{@$assignment->id }}">
                                                            <a class="dropdown-item edit_brand"
                                                               data-bs-toggle="modal"
                                                               data-bs-target="#viewAttachment{{$assignment->id}}"
                                                               href="#">{{__('common.View')}}</a>

                                                            <a href="{{route('assignment_assign',$assignment->id)}}"
                                                               title="{{__('assignment.Assign')}}"
                                                               class="dropdown-item modalLink"
                                                               data-modal-size="modal-lg">{{__('assignment.Assign')}}</a>

                                                            <a class="dropdown-item edit_brand"
                                                               href="{{route('assignment_edit',$assignment->id)}}">{{__('common.Edit')}}</a>
                                                            <a class="dropdown-item edit_brand"
                                                               href="{{route('assignment_marking',$assignment->id)}}">{{__('assignment.Marking')}}</a>
                                                            <a onclick="confirm_modal('{{route('assignment_delete', $assignment->id)}}');"
                                                               class="dropdown-item edit_brand">{{__('common.Delete')}}</a>
                                                        </div>
                                                    </div>
                                                </td>
                                            </tr>

                                            {{-- @include('assignment::attachment_view') --}}
                                            <div class="modal fade admin-query" id="viewAttachment{{$assignment->id}}">
                                                <div class="modal-dialog modal_1000px modal-dialog-centered">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h4 class="modal-title">{{__('common.View')}} {{__('assignment.Attachment')}}</h4>
                                                            <button type="button" class="close "
                                                                    data-bs-dismiss="modal">
                                                                <i class="ti-close "></i>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">

                                                            {!! @$assignment->description !!}
                                                            <hr>
                                                            @php
                                                                $std_file =$assignment->attachment;
                                                                $ext =strtolower(str_replace('"]','',pathinfo($std_file, PATHINFO_EXTENSION)));
                                                                $attached_file=str_replace('"]','',$std_file);
                                                                $attached_file=str_replace('["','',$attached_file);
                                                                $preview_files=['jpg','jpeg','png','heic','mp4','mov','mp3','mp4','pdf'];
                                                            @endphp
                                                            @if ($ext=='jpg' || $ext=='jpeg' || $ext=='png' || $ext=='heic')
                                                                <img class="img-responsive mt-20"
                                                                     style="width: 100%; height:auto"
                                                                     src="{{asset($attached_file)}}">
                                                            @elseif($ext=='mp4' || $ext=='mov')
                                                                <video class="mt-20 video_play" width="100%" controls>
                                                                    <source src="{{asset($attached_file)}}"
                                                                            type="video/mp4">
                                                                    <source src="mov_bbb.ogg" type="video/ogg">
                                                                    Your browser does not support HTML video.
                                                                </video>
                                                            @elseif($ext=='mp3')
                                                                <audio class="mt-20 audio_play" controls
                                                                       style="width: 100%">
                                                                    <source src="{{asset($attached_file)}}"
                                                                            type="audio/ogg">
                                                                    <source src="horse.mp3" type="audio/mpeg">
                                                                    Your browser does not support the audio element.
                                                                </audio>
                                                            @elseif($ext=='pdf')
                                                                <object data='{{asset($attached_file)}}'
                                                                        type="application/pdf" width="100%"
                                                                        height="800">
                                                                    <iframe src='{{asset($attached_file)}}' width="100%"
                                                                            height="800">
                                                                        <p>This browser does not support PDF!</p>
                                                                    </iframe>
                                                                </object>
                                                            @endif
                                                            @if (!in_array($ext,$preview_files))
                                                                <div class="alert alert-warning">
                                                                    {{$ext}} File Not Previewable</a>.
                                                                </div>
                                                            @endif
                                                            <div class="mt-40 d-flex justify-content-between">
                                                                {{-- <button type="button" class="primary-btn tr-bg" data-bs-dismiss="modal">@lang('lang.cancel')</button> --}}
                                                                @php
                                                                    $set_filename=time().'_'.$std_file;
                                                                @endphp
                                                                @if (file_exists($attached_file))

                                                                    <a class="primary-btn radius_30px fix-gr-bg"
                                                                       download="{{$set_filename}}"
                                                                       href="{{asset($attached_file)}}"> <span
                                                                            class="pl ti-download"> {{__('common.Download')}}</span></a>
                                                                @endif

                                                                {{-- {{route('download-uploaded-content-admin',$uploadedContent->id)}} --}}
                                                            </div>
                                                            <hr>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>

                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <div class="has-modal modal fade" id="showDetaildModal">
        <div class="modal-dialog modal-dialog-centered" id="modalSize">
            <div class="modal-content">
                <!-- Modal Header -->
                <div class="modal-header">
                    <h4 class="modal-title" id="showDetaildModalTile">@lang('lang.new_client_information')</h4>
                    <button type="button" class="close icons" data-bs-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body" id="showDetaildModalBody">

                </div>
            </div>
        </div>
    </div>

    @include('assignment::assign_student')


    <div id="edit_form">

    </div>
    <div id="view_details">

    </div>
    <input type="hidden" name="status_route" class="status_route" value="{{ route('coupons.status_update') }}">

    @include('backend.partials.delete_modal')

@endsection
@push('scripts')
    <script src="{{asset('public/backend/js/category.js')}}"></script>

    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {
                $("body").on("click", ".modalLink", function (e) {

                    e.preventDefault();
                    $(".modal-backdrop").show();
                    $("#showDetaildModal").show();
                    $("div.modal-dialog").removeClass("modal-md");
                    $("div.modal-dialog").removeClass("modal-lg");
                    $("div.modal-dialog").removeClass("modal-bg");
                    var modal_size = $(this).attr("data-modal-size");
                    if (
                        modal_size !== "" &&
                        typeof modal_size !== typeof undefined &&
                        modal_size !== false
                    ) {
                        $("#modalSize").addClass(modal_size);
                    } else {
                        $("#modalSize").addClass("modal-md");
                    }
                    var title = $(this).attr("title");
                    $("#showDetaildModalTile").text(title);
                    var data_title = $(this).attr("data-original-title");
                    $("#showDetaildModalTile").text(data_title);
                    $("#showDetaildModal").modal("show");
                    $("div.ajaxLoader").show();
                    $.ajax({
                        type: "GET",
                        url: $(this).attr("href"),
                        success: function (data) {
                            $("#showDetaildModalBody").html(data);
                            $("#showDetaildModal").modal("show");
                        },
                    });
                    console.log(e);
                });
            });
        })(jQuery);

    </script>
@endpush
