<?php

namespace Modules\Store\Exports\DropDownSheets;

use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Concerns\WithTitle;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Events\AfterSheet;
use Modules\Store\Entities\ProductAuthor;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AuthorList implements FromQuery, WithTitle, WithMapping, WithEvents
{


    public function query()
    {
        return ProductAuthor::query()
            ->where('status', 1);
    }

    /**
     * @return string
     */
    public function title(): string
    {
        return 'product_authors';
    }


    public function map($product_author): array
    {
        return [
            $product_author->title
        ];
    }

    public function registerEvents(): array
    {
        return [
            AfterSheet::class => function (AfterSheet $event) {
                $event->sheet->setSheetState(Worksheet::SHEETSTATE_HIDDEN);
            },
        ];
    }
}
