<?php


Route::prefix('tax')->as('tax.')->middleware(['auth', 'admin'])->group(function () {
    Route::get('/setting', 'TaxSettingController@index')->name('setting.index')->middleware('RoutePermissionCheck:tax.setting.index');
    Route::post('/setting', 'TaxSettingController@store')->name('setting.store')->middleware(['RoutePermissionCheck:tax.setting.index', 'demo']);


    Route::get('/country-wish-tax', 'TaxController@index')->name('country-wish-tax.index')->middleware('RoutePermissionCheck:tax.setting.index');
    Route::post('/country-wish-tax', 'TaxController@store')->name('country-wish-tax.store')->middleware(['RoutePermissionCheck:tax.setting.index', 'demo']);
    Route::get('/country-wish-tax/{tax_id}', 'TaxController@edit')->name('country-wish-tax.edit')->middleware('RoutePermissionCheck:tax.setting.index');
    Route::post('/country-wish-tax-update', 'TaxController@update')->name('country-wish-tax.update')->middleware(['RoutePermissionCheck:tax.setting.index', 'demo']);
    Route::get('/country-wish-tax-delete/{tax_id}', 'TaxController@delete')->name('country-wish-tax.delete')->middleware('RoutePermissionCheck:tax.setting.index');

});

