<?php
    $table_name='blogs';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <link rel="stylesheet"
          href="<?php echo e(asset('Modules/Blog/Resources/views/assets/taginput/tagsinput.css')); ?><?php echo e(assetVersion()); ?>"/>

    <?php echo generateBreadcrumb(); ?>


    <div class="row">
        <div class="col-lg-12">
            <div class="white-box">
                <form action="<?php echo e(route('blogs.index')); ?>" method="GET" class="form-horizontal" id="search_group">
                <div class="row">


                    <div class="col-lg-4 mt-30-md  ">
                        <label class="primary_input_label" for="category_id"><?php echo e(__('common.Category')); ?>

                        </label>
                        <select class="primary_select "
                                id="category" name="category">
                            <option data-display=" <?php echo e(__('common.Select')); ?>" value=""> <?php echo e(__('common.Category')); ?>

                            </option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option
                                    value="<?php echo e($cat->id); ?>" <?php echo e(request('category')==$cat->id?'selected':''); ?>><?php echo e($cat->title); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                    </div>



                </div>
                <div class="row">
                    <div class="col-lg-4-md mt-3 ">
                        <label class="primary_input_label" for=""  ></label>
                        <button type="submit" class="primary-btn   fix-gr-bg">
                            <span class="ti-search pe-2"></span>
                            <?php echo e(__('quiz.Search')); ?>

                        </button>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>


    <section class="admin-visitor-area up_st_admin_visitor">
        <div class="container-fluid p-0">

            <div class="row justify-content-center mt-30">

                <div class="col-lg-12">
                    <div class="white-box">
                        <div class="row">
                            <div class="col-12">
                                <div class="box_header common_table_header">
                                    <div class="main-title d-md-flex">
                                        <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px" id="page_title"><?php echo e(__('blog.Post List')); ?></h3>
                                        <?php if(permissionCheck('blogs.store')): ?>
                                            <ul class="d-flex">
                                                <li><a class="primary-btn radius_30px   fix-gr-bg "
                                                       href="<?php echo e(route('blogs.create')); ?>"><i
                                                            class="ti-plus"></i><?php echo e(__('common.Add')); ?> <?php echo e(__('blog.Blog')); ?>

                                                    </a>
                                                </li>
                                            </ul>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="QA_section QA_section_heading_custom check_box_table">
                                    <div class="QA_table ">
                                        <!-- table-responsive -->
                                        <div class="">

                                            <table id="lms_table" class="table Crm_table_active_blog">
                                                <thead>
                                                <tr>
                                                    <th scope="col"> <?php echo e(__('blog.SL')); ?></th>
                                                    <th scope="col"> <?php echo e(__('blog.Title')); ?></th>
                                                    <th scope="col"> <?php echo e(__('common.Category')); ?></th>
                                                    <?php if(isModuleActive('Org')): ?>
                                                        <th scope="col"> <?php echo e(__('org.Org Chart')); ?></th>
                                                        <th scope="col"> <?php echo e(__('org.Job Position')); ?></th>
                                                    <?php endif; ?>
                                                    <th scope="col"> <?php echo e(__('common.Tags')); ?></th>
                                                    <th scope="col"> <?php echo e(__('blog.Authored Date')); ?></th>
                                                    <th scope="col"> <?php echo e(__('blog.Viewed')); ?></th>
                                                    <th scope="col"><?php echo e(__('common.Status')); ?></th>
                                                    <th scope="col"><?php echo e(__('common.Action')); ?></th>

                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td class=""><span
                                                                class="m-2"><?php echo e(translatedNumber(++$key)); ?></span></td>
                                                        <td><?php echo e(@$blog->title); ?></td>
                                                        <td><?php echo e(@$blog->category->title); ?></td>
                                                        <?php if(isModuleActive('Org')): ?>
                                                            <td>
                                                                <?php if($blog->audience==1): ?>
                                                                    <?php echo e(trans('blog.Public')); ?>

                                                                <?php else: ?>

                                                                    <a type="button"
                                                                       class="primary-btn radius_30px   fix-gr-bg text-white  btn-modal"
                                                                       data-container="#commonModal"
                                                                       href="<?php echo e(routeIsExist('org.branch.blog')?route('org.branch.blog',$blog->id):''); ?>">
                                                                        <?php echo e(trans('blog.Specify')); ?>

                                                                    </a>
                                                                <?php endif; ?>
                                                            </td>

                                                            <td>
                                                                <?php if($blog->position_audience==1): ?>
                                                                    <?php echo e(trans('common.All')); ?>

                                                                <?php else: ?>
                                                                    <a type="button"
                                                                       class="primary-btn radius_30px   fix-gr-bg text-white  btn-modal"
                                                                       data-container="#commonModal"
                                                                       href="<?php echo e(routeIsExist('org.position.blog')?route('org.position.blog',$blog->id):''); ?>">
                                                                        <?php echo e(trans('blog.Specify')); ?>

                                                                    </a>
                                                                <?php endif; ?>
                                                            </td>
                                                        <?php endif; ?>
                                                            <td><?php echo e(@$blog->tags); ?></td>
                                                        <td>
                                                            <p class="text-nowrap">
                                                                <?php echo e(showDate(@$blog->authored_date )); ?>

                                                            </p>
                                                            <p class="text-nowrap">
                                                                <?php echo e($blog->authored_time); ?>

                                                            </p>
                                                        </td>
                                                        <td><?php echo e(translatedNumber($blog->viewed)); ?></td>
                                                        <td>
                                                            <?php if(permissionCheck('blogs.changeStatus')): ?>
                                                                <label class="switch_toggle">
                                                                    <input type="checkbox" class="status_enable_disable"
                                                                           <?php if(@$blog->status == 1): ?> checked
                                                                           <?php endif; ?> value="<?php echo e(@$blog->id); ?>">
                                                                    <i class="slider round"></i>
                                                                </label>
                                                            <?php else: ?>
                                                                <?php echo e($blog->status == 1?trans('common.Active'):trans('common.Inactive')); ?>

                                                            <?php endif; ?>
                                                        </td>
                                                        <td>
                                                            <div class="dropdown CRM_dropdown">
                                                                <button class="btn btn-secondary dropdown-toggle"
                                                                        type="button"
                                                                        id="dropdownMenu2" data-bs-toggle="dropdown"
                                                                        aria-haspopup="true"
                                                                        aria-expanded="false">
                                                                    <?php echo e(__('common.Action')); ?>

                                                                </button>
                                                                <div class="dropdown-menu dropdown-menu-right"
                                                                     aria-labelledby="dropdownMenu2">
                                                                    <a target="_blank"
                                                                       href="<?php echo e(route('blogDetails',[$blog->slug])); ?>?preview=1"
                                                                       class="dropdown-item"
                                                                       type="button"><?php echo e(__('common.View')); ?></a>
                                                                    <?php if(permissionCheck('blogs.update')): ?>
                                                                        <a href="<?php echo e(route('blogs.edit',$blog->id)); ?>"
                                                                           class="dropdown-item"
                                                                        ><?php echo e(__('common.Edit')); ?></a>
                                                                    <?php endif; ?>
                                                                    <?php if(permissionCheck('blogs.destroy')): ?>
                                                                        <button data-id="<?php echo e($blog->id); ?>"
                                                                                class="deleteBlog dropdown-item"
                                                                                type="button"><?php echo e(__('common.Delete')); ?></button>

                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


                <div class="modal fade admin-query" id="deleteBlog">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <form action="<?php echo e(route('blogs.destroy')); ?>"
                                  method="post">
                                <?php echo csrf_field(); ?>

                                <div class="modal-header">
                                    <h4 class="modal-title"><?php echo e(__('common.Delete')); ?> <?php echo e(__('blog.Blog')); ?> </h4>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"><i
                                            class="ti-close "></i></button>
                                </div>

                                <div class="modal-body">
                                    <div class="text-center">

                                        <h4><?php echo e(__('common.Are you sure to delete ?')); ?> </h4>
                                    </div>

                                    <div class="mt-40 d-flex justify-content-between">

                                        <input type="hidden" name="id" value="" id="blogDeleteId">
                                        <button type="button" class="primary-btn tr-bg"
                                                data-bs-dismiss="modal"><?php echo e(__('common.Cancel')); ?></button>
                                        <button class="primary-btn fix-gr-bg"
                                                type="submit"><?php echo e(__('common.Delete')); ?></button>


                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <script src="<?php echo e(asset('public/backend/js/blog_list.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>

    <script src="<?php echo e(asset('Modules/Blog/Resources/views/assets/taginput/tagsinput.js')); ?>"></script>

    <script>
        dataTableOptions.columns = [
            {orderable: true},
            {orderable: true},
                <?php if(isModuleActive('Org')): ?>
            {
                orderable: false
            }, {
                orderable: false
            },
                <?php endif; ?>
            {
                orderable: true
            },
            {orderable: true},
            {orderable: true},
            {orderable: true},
            {orderable: false},
            {orderable: false},

        ];
        <?php if(isModuleActive('Org')): ?>

        dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5, 6]);
<?php else: ?>
    dataTableOptions = updateColumnExportOption(dataTableOptions, [0, 1, 2, 3, 4, 5]);

    <?php endif; ?>
        let datatable = $('.Crm_table_active_blog').DataTable(dataTableOptions);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Blog/Resources/views/index.blade.php ENDPATH**/ ?>