<?php use Illuminate\Support\Facades\Auth; ?>

<?php $__env->startSection('title'); ?>
    <?php echo e(Settings('site_title') ? Settings('site_title') : 'Infix LMS'); ?> | <?php echo app('translator')->get('chat.chat'); ?> <?php echo app('translator')->get('chat.settings'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>
    <?php
        $isStudentPanel =Auth::user()->role_id==3
    ?>
    <?php if(!$isStudentPanel): ?>
        <?php echo e(generateBreadcrumb()); ?>

    <?php endif; ?>
    <section class="main_content_iner main_content_padding" id="admin-visitor-area">
        <div class="container-fluid p-0">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="">
                        <div class="row">
                            <div class="col-lg-12">

                                <div class="white-box">
                                    <div class="main-title">
                                        <h3 class="mb-0">
                                            <?php echo app('translator')->get('chat.chatting'); ?> <?php echo app('translator')->get('chat.method'); ?> <?php echo app('translator')->get('chat.settings'); ?>
                                        </h3>
                                    </div>

                                    <form action="<?php echo e(route('chat.settings')); ?>" method="post"
                                          class=" rounded mt-3">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <p class="text-uppercase"><?php echo app('translator')->get('chat.chat'); ?> <?php echo app('translator')->get('chat.settings'); ?></p>
                                                <div class="d-flex  radio-btn-flex">
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="chat_method" id="relationFather6343"
                                                               value="pusher"
                                                               class="common-radio relationButton" <?php echo e(env('BROADCAST_DRIVER') == 'pusher' ? 'checked' : ''); ?>>
                                                        <label for="relationFather6343"><?php echo app('translator')->get('chat.pusher'); ?></label>
                                                    </div>
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="chat_method" id="relationMother733"
                                                               value="jquery"
                                                               class="common-radio relationButton" <?php echo e(env('BROADCAST_DRIVER') == null ? 'checked' : ''); ?>>
                                                        <label for="relationMother733"><?php echo app('translator')->get('chat.jquery'); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" id="pusher" style="display: none">
                                            <div class="col-xl-6">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('setting.pusher_app_id')); ?></label>
                                                    <input class="primary_input_field" placeholder="-" type="text"
                                                           name="pusher_app_id" value="<?php echo e(env('PUSHER_APP_ID')); ?>">
                                                </div>
                                            </div>

                                            <div class="col-xl-6">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('setting.pusher_app_key')); ?></label>
                                                    <input class="primary_input_field" placeholder="-" type="text"
                                                           name="pusher_app_key" value="<?php echo e(env('PUSHER_APP_KEY')); ?>">
                                                </div>
                                            </div>
                                            <div class="col-xl-6">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('setting.pusher_app_secret')); ?></label>
                                                    <input class="primary_input_field" placeholder="-" type="text"
                                                           name="pusher_app_secret"
                                                           value="<?php echo e(env('PUSHER_APP_SECRET')); ?>">
                                                </div>
                                            </div>

                                            <div class="col-xl-6">
                                                <div class="primary_input mb-25">
                                                    <label class="primary_input_label"
                                                           for=""><?php echo e(__('setting.pusher_app_cluster')); ?></label>
                                                    <input class="primary_input_field" placeholder="-" type="text"
                                                           name="pusher_app_cluster"
                                                           value="<?php echo e(env('PUSHER_APP_CLUSTER')); ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <button class="primary-btn small fix-gr-bg"><i
                                                class="ti-check"></i><?php echo app('translator')->get('chat.update'); ?></button>
                                    </form>
                                </div>

                                <div class="white-box mt_30">
                                    <!-- SMTP form  -->
                                    <div class="main-title  ">
                                        <h3 class="mb-0"><?php echo app('translator')->get('chat.chat'); ?> <?php echo app('translator')->get('chat.settings'); ?></h3>
                                    </div>
                                    <form action="<?php echo e(route('chat.settings.permission.store')); ?>" method="post"
                                          class=" rounded mt-3">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <p class="text-uppercase  "><?php echo app('translator')->get('chat.admin_can_chat_without_invitation'); ?></p>
                                                <div class="d-flex  radio-btn-flex">
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="admin_can_chat_without_invitation"
                                                               id="relationFather3" value="yes"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_admin_can_chat_without_invitation') == 'yes' ? 'checked' : ''); ?>>
                                                        <label for="relationFather3"><?php echo app('translator')->get('chat.yes'); ?></label>
                                                    </div>
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="admin_can_chat_without_invitation"
                                                               id="relationMother4" value="no"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_admin_can_chat_without_invitation') == 'no' ? 'checked' : ''); ?>>
                                                        <label for="relationMother4"><?php echo app('translator')->get('chat.no'); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <p class="text-uppercase mb-0"><?php echo app('translator')->get('chat.open_chat_system'); ?></p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="open_chat_system" id="relationFather5"
                                                               value="yes"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_open') == 'yes' ? 'checked' : ''); ?>>
                                                        <label for="relationFather5"><?php echo app('translator')->get('chat.yes'); ?></label>
                                                    </div>
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="open_chat_system" id="relationMother6"
                                                               value="no"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_open') == 'no' ? 'checked' : ''); ?>>
                                                        <label for="relationMother6"><?php echo app('translator')->get('chat.no'); ?></label>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <button class="primary-btn small fix-gr-bg"><i
                                                class="ti-check"></i><?php echo app('translator')->get('chat.update'); ?></button>
                                    </form>
                                </div>


                                <div class="white-box mt_30">
                                    <!-- SMTP form  -->
                                    <div class="main-title mb-25">
                                        <h3 class="mb-0 text-nowrap"><?php echo app('translator')->get('chat.invitation'); ?> <?php echo app('translator')->get('chat.settings'); ?></h3>
                                    </div>
                                    <form action="<?php echo e(route('chat.invitation.requirement')); ?>" method="post"
                                          class=" rounded mt-3">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <p class="text-uppercase mb-0"><?php echo app('translator')->get('chat.invitation'); ?> <?php echo app('translator')->get('chat.requirement'); ?></p>
                                                <div class="d-flex  radio-btn-flex">
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="invitation_requirement"
                                                               id="relationFather6" value="required"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_invitation_requirement') == 'required' ? 'checked' : ''); ?>>
                                                        <label for="relationFather6"><?php echo app('translator')->get('chat.required'); ?></label>
                                                    </div>
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="invitation_requirement"
                                                               id="relationMother7" value="none"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_invitation_requirement') == 'none' ? 'checked' : ''); ?>>
                                                        <label
                                                            for="relationMother7"><?php echo app('translator')->get('chat.not'); ?> <?php echo app('translator')->get('chat.required'); ?></label>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        <button class="primary-btn small fix-gr-bg"><i
                                                class="ti-check"></i><?php echo app('translator')->get('chat.update'); ?></button>
                                    </form>
                                </div>

                                <?php if( is_null(Settings('chat_generate')) || Settings('chat_generate') != 'generated'): ?>
                                    <div class="white-box mt_30">
                                        <div class="main-title mb-25">
                                            <h3 class="mb-0"><?php echo app('translator')->get('chat.generate'); ?> <?php echo app('translator')->get('chat.connections'); ?></h3>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 mb-3">
                                                <form action="<?php echo e(route('chat.invitation.generate','single')); ?>"
                                                      method="get" class=" rounded mt-3">
                                                    <p class="text-uppercase mb-0">
                                                        <?php echo app('translator')->get('chat.generate'); ?> <?php echo app('translator')->get('chat.teacher'); ?> <?php echo app('translator')->get('chat.and'); ?> <?php echo app('translator')->get('chat.student'); ?> <?php echo app('translator')->get('chat.connection'); ?> <?php echo app('translator')->get('chat.for'); ?> <?php echo app('translator')->get('chat.old'); ?> <?php echo app('translator')->get('chat.courses'); ?>
                                                    </p>
                                                    <br>
                                                    <button class="primary-btn radius_30px  fix-gr-bg"><i
                                                            class="ti-check"></i><?php echo app('translator')->get('chat.generate'); ?></button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="white-box mt_30">
                                    <!-- SMTP form  -->
                                    <div class="main-title mb-25">
                                        <h3 class="mb-0"><?php echo app('translator')->get('chat.permission'); ?> <?php echo app('translator')->get('chat.settings'); ?></h3>
                                    </div>
                                    <form action="<?php echo e(route('chat.settings.edu')); ?>" method="post"
                                          class=" rounded mt-3">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <p class="text-uppercase mb-0"><?php echo app('translator')->get('chat.can_upload_file'); ?></p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="can_upload_file"
                                                               id="relationFather6334" value="yes"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_can_upload_file') == 'yes' ? 'checked' : ''); ?>>
                                                        <label for="relationFather6334"><?php echo app('translator')->get('chat.yes'); ?></label>
                                                    </div>
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="can_upload_file"
                                                               id="relationMother7334" value="no"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_can_upload_file') == 'no' ? 'checked' : ''); ?>>
                                                        <label for="relationMother7334"><?php echo app('translator')->get('chat.no'); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <div class="primary_input">
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <label class="primary_input_label"
                                                                   for=""><?php echo app('translator')->get('chat.upload_file_limit'); ?>
                                                                (<?php echo app('translator')->get('chat.mb'); ?>)</label>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <input class="primary_input_field" placeholder="-"
                                                                   type="number" name="file_upload_limit"
                                                                   value="<?php echo e(Settings('chat_file_limit') ?? 0); ?>">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <div
                                                class="col-lg-6 d-flex flex-wrap relation-button justify-content-between mb-3 radio-btn-flex">
                                                <p class="text-uppercase mb-0"><?php echo app('translator')->get('chat.can_make_group'); ?></p>
                                                <div class="d-flex radio-btn-flex">
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="can_make_group" id="relationFather63"
                                                               value="yes"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_can_make_group') == 'yes' ? 'checked' : ''); ?>>
                                                        <label for="relationFather63"><?php echo app('translator')->get('chat.yes'); ?></label>
                                                    </div>
                                                    <div class="d-flex mr-20">
                                                        <input type="radio" name="can_make_group" id="relationMother73"
                                                               value="no"
                                                               class="common-radio relationButton" <?php echo e(Settings('chat_can_make_group') == 'no' ? 'checked' : ''); ?>>
                                                        <label for="relationMother73"><?php echo app('translator')->get('chat.no'); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button class="primary-btn small fix-gr-bg"><i
                                                class="ti-check"></i><?php echo app('translator')->get('chat.update'); ?></button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        (function ($) {
            "use strict";
            $(document).ready(function () {
                let method = $('input[name="chat_method"]:checked').val();
                if (method == 'pusher') {
                    $('#pusher').css('display', '');
                    $('#jquery').hide();
                    $('#pusher').show();
                } else {
                    $('#pusher').hide();
                }
                $('input[name=chat_method]').change(function () {
                    let method = $('input[name="chat_method"]:checked').val();
                    if (method == 'pusher') {
                        $('#jquery').hide();
                        $('#pusher').show();
                    } else {
                        $('#pusher').hide();
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make(app('extend_view'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Chat/Resources/views/settings.blade.php ENDPATH**/ ?>