<div class="tab-pane fade <?php if(Session::has('subscription')): ?>show active <?php endif; ?> " id="Subscription"
     role="tabpanel"
     aria-labelledby="General-tab">
    <div class="white-box">
        <div class="main-title mb-25">
            <h3 class="mb-0"><?php echo e(__('setting.Specific Subscription Commission Setup')); ?> </h3>
        </div>

        <form
            action="<?php echo e(route('affiliate.commission.settings.subscription')); ?>"
            method="post">
            <?php echo csrf_field(); ?>
            <div class="row">

                <div class="col-lg-4 mb-10 mtr-15">
                    <div class="input-effect">
                        <label class="primary_input_label"
                               for=""><?php echo e(__('affiliate.Commission Type')); ?> <span
                                class="required_mark_theme">*</span></label>

                        <div class="row">
                            <div class="col-md-6">
                                <label class="primary_checkbox d-flex mr-12"
                                       for="subscription_commission_type_1">
                                    <input
                                        Checked type="radio"
                                        id="subscription_commission_type_1"
                                        class="subscription_commission_type common-checkbox form-control<?php echo e($errors->has('subscription_commission_type') ? ' is-invalid' : ''); ?>"
                                        name="subscription_commission_type" value="Percentage">
                                    <span
                                        class="checkmark me-2"></span> <?php echo e(__('affiliate.Percentage')); ?>

                                </label>
                            </div>
                            <div class="col-md-6">
                                <label class="primary_checkbox d-flex mr-12"
                                       for="subscription_commission_type_2">
                                    <input
                                        type="radio"
                                        id="subscription_commission_type_2"
                                        class="subscription_commission_type common-checkbox form-control<?php echo e($errors->has('subscription_commission_type') ? ' is-invalid' : ''); ?>"
                                        name="subscription_commission_type" value="Flat">
                                    <span
                                        class="checkmark me-2"></span> <?php echo e(__('affiliate.Flat')); ?>

                                </label>
                            </div>
                        </div>


                    </div>
                </div>

                <div class="col-lg-4 mb-10">
                    <div class="input-effect">
                        <label class="mb-2">
                                                        <span
                                                            class="commissionBundleTypePercentage  ">
                                                            <?php echo e(__('affiliate.Commission Percentage')); ?>

                                                        </span>

                            <span
                                class=" commissionBundleTypeAmount d-none">
                                                            <?php echo e(__('affiliate.Commission Amount')); ?>

                                                        </span>

                            <span
                                class="required_mark_theme">*</span> </label>
                        <input
                            class="primary-input-field form-control<?php echo e($errors->has('subscription_commission_amount') ? ' is-invalid' : ''); ?>"
                            type="number" name="subscription_commission_amount" autocomplete="off" min="0"
                            value="0">

                    </div>
                </div>

                <div class="col-xl-4">
                    <div class="primary_input mb-25">
                        <label class="primary_input_label"
                               for=""><?php echo e(__('common.Select')); ?> <?php echo e(__('subscription.Subscription')); ?></label>
                        <select name="subscription[]"  class="multypol_check_select active mb-15"
                                multiple>
                            <option value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('subscription.Subscription')); ?></option>

                            <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <option value="<?php echo e(@$plan->id); ?>">
                                    <?php echo e(@$plan->title); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>


                <div class="col-12 mb-10 ">
                    <div class="submit_btn text-center">
                        <button class="primary-btn fix-gr-bg" type="submit"><i
                                class="ti-check"></i> <?php echo e(__('common.Update')); ?> <?php echo e(__('setting.Setting')); ?>

                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
    <div class="col-lg-12 mt-20 p-0">
        <div class="box_header">
            <div class="main-title d-flex flex-wrap mb-0">
                <h3 class="mb-0"><?php echo e(__('setting.Specific Plan List')); ?></h3>
            </div>
        </div>

        <div class="QA_section QA_section_heading_custom check_box_table">
            <div class="QA_table ">
                <!-- table-responsive -->
                <div class="">
                    <table id="lms_table" class="table Crm_table_active3">
                        <thead>
                        <tr>
                            <th scope="col"> <?php echo e(__('common.SL')); ?> </th>
                            <th scope="col"> <?php echo e(__('common.Title')); ?> </th>
                            <th scope="col"><?php echo e(__('affiliate.Commission Type')); ?></th>
                            <th scope="col">     <?php echo e(__('affiliate.Amount')); ?> / <?php echo e(__('affiliate.Percentage')); ?></th>
                            <th scope="col"> <?php echo e(__('common.Action')); ?> </th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $commissions->where('commission_for','subscription'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$commission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <td><?php echo e(++$key); ?></td>
                                <td class="nowrap"><?php echo e(@$commission->commable->title); ?></td>
                                <td class="nowrap"><?php echo e(@$commission->type==1?trans('affiliate.Percentage'):trans('affiliate.Flat')); ?></td>
                                <td class="nowrap"><?php echo e($commission->type==1?($commission->amount.'%'):getPriceFormat($commission->amount)); ?></td>
                                <td class="nowrap">

                                    <div class="dropdown CRM_dropdown">
                                        <button class="btn btn-secondary dropdown-toggle"
                                                type="button"
                                                id="dropdownMenu3<?php echo e(@$commission->id); ?>"
                                                data-bs-toggle="dropdown"
                                                aria-haspopup="true"
                                                aria-expanded="false">
                                            <?php echo e(__('common.Action')); ?>

                                        </button>
                                        <div class="dropdown-menu dropdown-menu-right"
                                             aria-labelledby="dropdownMenu3<?php echo e(@$commission->id); ?>">
                                            <a class="dropdown-item btn-modal"
                                               data-container="#commonModal"
                                               href="<?php echo e(route('affiliate.commission.ajaxDeleteForm',@$commission->id)); ?>"
                                               type="button">
                                                <?php echo e(__('common.Delete')); ?></a>

                                        </div>
                                    </div>
                                </td>

                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/minialms/card.minialms.com/Modules/Affiliate/Resources/views/commissions/partials/subscription.blade.php ENDPATH**/ ?>