<?php use Carbon\Carbon; ?>

<?php $__env->startPush('styles'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/backend/css/class.css')); ?>"/>
<?php $__env->stopPush(); ?>
<?php
    $table_name = 'courses';
?>
<?php $__env->startSection('table'); ?>
    <?php echo e($table_name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>

    <section class="admin-visitor-area up_st_admin_visitor">


        <div class="white_box mb_30  student-details header-menu">
            <div class="white_box_tittle list_header">
                <h4> <?php echo e($data['title']); ?></h4>
            </div>
            <div class="col-lg-12">

                <input type="hidden" id="url" value="<?php echo e(url('/')); ?>">
                <?php
                    $LanguageList = getLanguageList();
                    $specific_target_ids=old('target')? old(old('target')) : [];
                    $target_item = isset($data['plan']) ? $data['plan']->plan_specific_item->plan_specific_item_details() : $specific_target_ids;
                    $upfront_payment = isset($data['plan']) ? $data['plan']->paymentSteps->where('payment_title', 'Upfront')->first() : [];
                ?>
                <?php if(isset($data['plan'])): ?>
                    <form action="<?php echo e(route('installment.plan.update')); ?>" method="post" id="plan_save_form"
                          enctype="multipart/form-data">
                        <input type="text" hidden name="id" value="<?php echo e($data['plan']->id); ?>">
                        <?php else: ?>
                            <form action="<?php echo e(route('installment.plan.store')); ?>" method="post" id="plan_save_form"
                                  enctype="multipart/form-data">
                                <?php endif; ?>
                                <?php echo csrf_field(); ?>
                                <div class="row pt-0">
                                    <?php if(isModuleActive('FrontendMultiLang')): ?>
                                        <ul class="nav nav-tabs no-bottom-border  mt-sm-md-20 mb-10 ms-3 mb-4"
                                            role="tablist">
                                            <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="nav-item">
                                                    <a class="nav-link  <?php if(auth()->user()->language_code == $language->code): ?> active <?php endif; ?>"
                                                       href="#element<?php echo e($language->code); ?>" role="tab"
                                                       data-bs-toggle="tab"><?php echo e($language->native); ?> </a>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                                <div class="tab-content">
                                    <?php $__currentLoopData = $LanguageList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div role="tabpanel"
                                             class="tab-pane fade <?php if(auth()->user()->language_code == $language->code): ?> show active <?php endif; ?>  "
                                             id="element<?php echo e($language->code); ?>">
                                            <div class="row">

                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex"
                                                               for=""><?php echo e(_trans('installment.Plan')); ?>

                                                            <?php echo e(__('common.Title')); ?> <span class="text-danger"> *</span>
                                                        </label>
                                                        <input class="primary_input_field"
                                                               name="title[<?php echo e($language->code); ?>]"
                                                               placeholder="-" id="addTitle" type="text"
                                                               <?php echo e($errors->has('title') ? 'autofocus' : ''); ?>

                                                               value="<?php echo e(isset($data['plan']) ? $data['plan']->getTranslation('title', $language->code) : (old('title') != null ? old('title.'.$language->code) :'')); ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-xl-12">
                                                    <div class="primary_input mb-35">
                                                        <label class="primary_input_label d-flex"
                                                               for=""><?php echo e(_trans('installment.Plan')); ?>

                                                            <?php echo e(_trans('installment.Description')); ?> <span
                                                                class="required_mark">*</span>
                                                        </label>
                                                        <textarea class="lms_summernote"
                                                                  name="description[<?php echo e($language->code); ?>]"
                                                                  id="addRequirements" cols="30"
                                                                  rows="10"><?php echo isset($data['plan']) ? $data['plan']->getTranslation('description', $language->code) : (old('description') != null ? old('description.'.$language->code) :''); ?></textarea>
                                                    </div>

                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="row">
                                    <div class="col-xl-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="">
                                                <?php echo e(_trans('installment.Capacity')); ?> <span class="text-danger"> *</span></label>
                                            <input class="primary_input_field" name="capacity" placeholder="-"
                                                   id="addCapacity"
                                                   type="number" <?php echo e($errors->has('capacity') ? 'autofocus' : ''); ?>

                                                   value="<?php echo e(isset($data['plan']) ? $data['plan']->capacity : (old('capacity') != null ? old('capacity') :'')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-xl-6">
                                        <div class=" mb-25">
                                            <?php if (isset($component)) { $__componentOriginal3c189c37dfafa3e6853f94906c245d36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3c189c37dfafa3e6853f94906c245d36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.upload-file','data' => ['name' => 'banner','required' => 'true','type' => 'image','mediaId' => ''.e(isset($data['plan'])?$data['plan']->banner_media?->media_id:'').'','label' => ''.e(__('installment.Banner')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('upload-file'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'banner','required' => 'true','type' => 'image','media_id' => ''.e(isset($data['plan'])?$data['plan']->banner_media?->media_id:'').'','label' => ''.e(__('installment.Banner')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $attributes = $__attributesOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $component = $__componentOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__componentOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>

                                        </div>
                                    </div>
                                </div>
                                <div class="row mb-4 align-items-center">
                                    <div class="col-lg-6">
                                        <h3 class="mb-0"><?php echo e(_trans('installment.Features')); ?> </h3>
                                    </div>
                                    <div class="col-lg-4">
                                        <a class="primary-btn radius_30px  w-fit  fix-gr-bg" id="add_new_feature"
                                           href="#"><i
                                                class="ti-plus"></i><?php echo e(_trans('installment.Add Feature')); ?> </a>
                                    </div>
                                </div>
                                <div id="feature_list">
                                    <?php if(old('features')): ?>
                                        <?php $__currentLoopData = old('features'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="primary_input mb-25">
                                                        <input class="primary_input_field" name="features[]"
                                                               placeholder="-"
                                                               id="addCapacity" type="text" value="<?php echo e($feature); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 mt_10">
                                                    <button type="button"
                                                            class="primary-btn icon-only fix-gr-bg w-fit removePlanFeature"><span
                                                            class="ti-trash  "></span></button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php elseif(isset($data['plan'])): ?>
                                        <?php $__currentLoopData = $data['plan']->features; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="primary_input mb-25">
                                                        <input class="primary_input_field" name="features[]"
                                                               placeholder="-"
                                                               id="addCapacity" type="text"
                                                               value="<?php echo e($feature->title); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-4 mt_10">
                                                    <button type="button"
                                                            class="primary-btn icon-only fix-gr-bg removePlanFeature"><span
                                                            class="ti-trash pe-2"></span></button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>

                                <div class="row mb-20">
                                    <div class="col-lg-3">
                                        <div class="primary_input">
                                            <label class="primary_input_label" for=""><?php echo e(__('coupons.Start Date')); ?>

                                                <span class="text-danger"> *</span></label>
                                            <div class="primary_datepicker_input">
                                                <div class="g-0  input-right-icon">
                                                    <div class="col">
                                                        <div class="">
                                                            <input placeholder="<?php echo e(__('coupons.Start Date')); ?>"
                                                                   class="primary_input_field primary-input date form-control  <?php echo e(@$errors->has('start_date') ? ' is-invalid' : ''); ?>"
                                                                   id="start_date" type="text" name="start_date"
                                                                   value="<?php echo e(isset($data['plan']) ? getJsDateFormat(\Carbon\Carbon::parse($data['plan']->start_datetime)->format(getActivePhpDateFormat())) : (old('start_date') ? old('start_date') :getJsDateFormat(date('m/d/Y')) )); ?>"
                                                                   autocomplete="off">

                                                        </div>
                                                    </div>
                                                    <button class="" type="button">
                                                        <i class="ti-calendar" id="start-date-icon"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label class="primary_input_label mt-1"><?php echo e(_trans('installment.Start Time')); ?>

                                            <span
                                                class="text-danger"> *</span></label>
                                        <div class="primary_input">
                                            <input required
                                                   class="primary-input primary_input_field  time form-control<?php echo e(@$errors->has('start_time') ? ' is-invalid' : ''); ?>"
                                                   type="text" name="start_time"
                                                   value="<?php echo e(isset($data['plan']) ? showTime($data['plan']->start_datetime) : old('start_time')); ?>">
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <div class="primary_input">
                                            <label class="primary_input_label"
                                                   for=""><?php echo e(_trans('installment.End Date')); ?></label>
                                            <div class="primary_datepicker_input">
                                                <div class="g-0  input-right-icon">
                                                    <div class="col">
                                                        <div class="">
                                                            <input placeholder="<?php echo e(_trans('installment.End Date')); ?>"
                                                                   class="primary_input_field primary-input date form-control  <?php echo e(@$errors->has('end_date') ? ' is-invalid' : ''); ?>"
                                                                   id="end_date" type="text" name="end_date"
                                                                   value="<?php echo e(isset($data['plan']->end_datetime) ? getJsDateFormat(Carbon::parse($data['plan']->end_datetime)->format(getActivePhpDateFormat())) : (old('end_date') ? old('end_date') :'')); ?>"
                                                                   autocomplete="off">

                                                        </div>
                                                    </div>
                                                    <button class="" type="button">
                                                        <i class="ti-calendar" id="start-date-icon"></i>
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-3">
                                        <label
                                            class="primary_input_label mt-1"><?php echo e(_trans('installment.End Time')); ?></label>
                                        <div class="primary_input">
                                            <input
                                                class="primary-input primary_input_field  time form-control<?php echo e(@$errors->has('end_time') ? ' is-invalid' : ''); ?>"
                                                type="text" name="end_time"
                                                value="<?php echo e(isset($data['plan']->end_datetime) ? showTime($data['plan']->end_datetime) : old('end_time')); ?>">
                                        </div>
                                    </div>
                                </div>
                                <h3>
                                    <?php echo e(_trans('installment.Target Products')); ?>

                                </h3>
                                <?php
                                    $selected_target_type=isset($data['plan']) ? $data['plan']->plan_specific_item->target_type : (old('target_type') ? old('target_type') : '');
                                    $selected_target=isset($data['plan']) ? $data['plan']->plan_specific_item->target : (old('target') ? old('target') : '');
                                ?>
                                <div class="row">
                                    <div class="col-lg-4">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for=""><?php echo e(_trans('installment.Target Type')); ?> <span
                                                    class="required_mark">*</span>
                                            </label>

                                            <select class="primary_select" name="target_type" id="select_target_type">
                                                <option data-display="<?php echo e(_trans('installment.Target Type')); ?>" value="">
                                                    <?php echo e(_trans('installment.Target Type')); ?> </option>
                                                <option value="all"
                                                    <?php echo e(isset($selected_target_type) ? ($selected_target_type == 'all' ? 'selected' : '') : ''); ?>>
                                                    <?php echo e(_trans('installment.All Type')); ?> </option>
                                                <option value="course"
                                                    <?php echo e(isset($selected_target_type) ? ($selected_target_type == 'course' ? 'selected' : '') : ''); ?>>
                                                    <?php echo e(_trans('installment.Course')); ?> </option>
                                                <option value="quiz"
                                                    <?php echo e(isset($selected_target_type) ? ($selected_target_type == 'quiz' ? 'selected' : '') : ''); ?>>
                                                    <?php echo e(_trans('installment.Quiz')); ?> </option>
                                                <option value="live_class"
                                                    <?php echo e(isset($selected_target_type) ? ($selected_target_type == 'live_class' ? 'selected' : '') : ''); ?>>
                                                    <?php echo e(_trans('installment.Live Class')); ?> </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-4" id="target_options" style="display: none">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for=""><?php echo e(_trans('installment.Select Target')); ?>

                                            </label>

                                            <select class="primary_select" name="target" id="target_item_options">
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-4" id="specific_section" style="display:none">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label" for="specific_item_select"
                                                   id="specic_item_lebel">
                                            </label>
                                            <select name="specific_item[]" id="specific_item_select"
                                                    class="multypol_check_select active mb-15 e1" multiple>

                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                    $old_validation_required=old('verification_required') ? (old('verification_required') == 1 ? 'checked' : ''):'';
                                ?>
                                <div class="row mt_20">
                                    <div class="col-xl-6">
                                        <div class="primary_input ">
                                            <div class="row">
                                                <div class="col-md-4 ">
                                                    <h3><?php echo e(_trans('installment.Verification')); ?> </h3>
                                                </div>
                                                <label class="switch_toggle" for="checkbox_varification">
                                                    <input type="checkbox" id="checkbox_varification"
                                                           <?php echo e(isset($data['plan']) ? ($data['plan']->verification_required == 1 ? 'checked' : '') : $old_validation_required); ?>

                                                           name="verification_required" value="1"
                                                           onchange="planVerification(this)">
                                                    <i class="slider round"></i>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="varification_section">
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="primary_input mb-35">
                                                <label class="primary_input_label d-flex"
                                                       for=""><?php echo e(_trans('installment.Verification')); ?>

                                                    <?php echo e(_trans('installment.Description')); ?>

                                                </label>
                                                <textarea class="lms_summernote" name="verification_description"
                                                          id="addRequirements" cols="30"
                                                          rows="10"><?php echo isset($data['plan']) ? $data['plan']->verification_description : old('verification_description'); ?></textarea>
                                            </div>
                                            <small>
                                                <?php echo e(_trans('installment.This description will be shown to the user when they are going to purchase the plan.')); ?>

                                            </small>
                                        </div>

                                    </div>
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class=" mb-25">
                                                <?php if (isset($component)) { $__componentOriginal3c189c37dfafa3e6853f94906c245d36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3c189c37dfafa3e6853f94906c245d36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.upload-file','data' => ['name' => 'verification_banner','required' => 'true','type' => 'image','mediaId' => ''.e(isset($data['plan'])?$data['plan']->verification_banner_media?->media_id:'').'','label' => ''.e(__('installment.Verification Banner')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('upload-file'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'verification_banner','required' => 'true','type' => 'image','media_id' => ''.e(isset($data['plan'])?$data['plan']->verification_banner_media?->media_id:'').'','label' => ''.e(__('installment.Verification Banner')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $attributes = $__attributesOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $component = $__componentOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__componentOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>

                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class=" mb-25">
                                                <?php if (isset($component)) { $__componentOriginal3c189c37dfafa3e6853f94906c245d36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3c189c37dfafa3e6853f94906c245d36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.upload-file','data' => ['name' => 'verification_video','type' => 'video','mediaId' => ''.e(isset($data['plan'])?$data['plan']->verification_video_media?->media_id:'').'','label' => ''.e(__('installment.Verification Video')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('upload-file'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'verification_video','type' => 'video','media_id' => ''.e(isset($data['plan'])?$data['plan']->verification_video_media?->media_id:'').'','label' => ''.e(__('installment.Verification Video')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $attributes = $__attributesOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $component = $__componentOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__componentOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                    $old_request_uploads=old('request_uploads') ? (old('request_uploads') == 1 ? 'checked' : ''):'';
                                ?>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex" for="upfront">
                                                <?php echo e(_trans('installment.Request Upload')); ?></label>
                                            <label class="switch_toggle" for="checkbox_request_upload">
                                                <input type="checkbox" id="checkbox_request_upload"
                                                       name="request_uploads"
                                                       <?php echo e(isset($data['plan']) ? ($data['plan']->request_uploads == 1 ? 'checked' : '') : $old_request_uploads); ?>

                                                       value="1">
                                                <i class="slider round"></i>
                                            </label>
                                        </div>
                                    </div>
                                    <?php
                                        $old_bypass_verification_for_verified_users=old('bypass_verification_for_verified_users') ? (old('bypass_verification_for_verified_users') == 1 ? 'checked' : ''):'';
                                    ?>
                                    <div class="col-lg-6">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for=""><?php echo e(_trans('installment.Bypass verification for verified users')); ?></label>

                                            <label class="switch_toggle" for="checkbox_bypass_verification">
                                                <input type="checkbox" id="checkbox_bypass_verification"
                                                       name="bypass_verification_for_verified_users"
                                                       <?php echo e(isset($data['plan']) ? ($data['plan']->bypass_verification_for_verified_users == 1 ? 'checked' : '') : $old_bypass_verification_for_verified_users); ?>

                                                       value="1">
                                                <i class="slider round"></i>
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <h3><?php echo e(_trans('installment.Payment')); ?> </h3>
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="primary_input mb-25">
                                            <label class="primary_input_label d-flex" for="upfront">
                                                <?php echo e(_trans('installment.Upfront')); ?> <span
                                                    class="text-danger"> (%)*</span></label>
                                            <input class="primary_input_field step_amount" name="upfront"
                                                   placeholder="-" id="upfront"
                                                   type="number" <?php echo e($errors->has('upfront') ? 'autofocus' : ''); ?>

                                                   value="<?php echo e(isset($data['plan']) ? $upfront_payment->payment_amount : old('upfront')); ?>"
                                            >
                                        </div>
                                    </div>
                                    <?php
                                        $installment_status=isset($data['plan']) ? $data['plan']->status : old('status');
                                    ?>
                                    <div class="col-lg-6">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for=""><?php echo e(_trans('installment.Installment Status')); ?> </label>

                                            <select class="primary_select" name="status">
                                                <option data-display="<?php echo e(_trans('installment.Installment Status')); ?>"
                                                        value=""><?php echo e(_trans('installment.Installment Status')); ?></option>
                                                <option
                                                    value="1" <?php echo e($installment_status == 1 ? 'selected' : ''); ?>><?php echo e(_trans('installment.Active')); ?> </option>
                                                <option
                                                    value="0" <?php echo e($installment_status == 0 ? 'selected' : ''); ?>><?php echo e(_trans('installment.Deactivate')); ?> </option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-lg-6" style="display:none">
                                        <div class="primary_input mb-35">
                                            <label class="primary_input_label"
                                                   for=""><?php echo e(_trans('installment.Upfront Type')); ?>

                                            </label>

                                            <select class="primary_select" name="upfront_type">
                                                <option data-display="<?php echo e(_trans('installment.Upfront Type')); ?>"
                                                        value="">
                                                    <?php echo e(_trans('installment.Upfront Type')); ?> </option>
                                                <option value="fixed_amount">
                                                    <?php echo e(_trans('installment.Fixed Amount')); ?> </option>
                                                <option value="percent" selected>
                                                    <?php echo e(_trans('installment.Percent')); ?> </option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="row align-items-cente mb-4">
                                    <div class="col-lg-9 d-flex align-items-center">
                                        <h3 class="mb-0"><?php echo e(_trans('installment.Payment Steps')); ?> </h3>

                                    </div>
                                    <div class="col-lg-2">
                                        <a class="primary-btn radius_30px  w-fit  fix-gr-bg" id="add_new_step" href="#"><i
                                                class="ti-plus"></i><?php echo e(_trans('installment.Add Step')); ?> </a>
                                    </div>
                                </div>

                                <div id="payment_step_list">
                                    <?php if(old('payment_steps')): ?>
                                        <?php $__currentLoopData = old('payment_steps'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex" for="payment_title">
                                                            <?php echo e(_trans('installment.Title')); ?> <span class="text-danger"> *</span></label>
                                                        <input class="primary_input_field payment_steps"
                                                               name="payment_steps[<?php echo e($key); ?>][payment_title]"
                                                               placeholder="-"
                                                               id="payment_title_<?php echo e($key); ?>" type="text"
                                                               value="<?php echo e($step['payment_title']); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex"
                                                               for="payment_deadline">
                                                            <?php echo e(_trans('installment.Deadline')); ?>

                                                            (<?php echo e(_trans('installment.Days')); ?>) <span class="text-danger"> *</span></label>
                                                        <input class="primary_input_field payment_steps"
                                                               name="payment_steps[<?php echo e($key); ?>][payment_deadline]"
                                                               placeholder="-"
                                                               id="payment_deadline" type="number"
                                                               value="<?php echo e($step['payment_deadline']); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex" for="payment_amount">
                                                            <?php echo e(_trans('installment.Amount')); ?>

                                                            (<?php echo e(_trans('installment.Percent')); ?>) <span
                                                                class="text-danger"> *</span></label>
                                                        <input class="primary_input_field payment_steps step_amount"
                                                               name="payment_steps[<?php echo e($key); ?>][payment_amount]"
                                                               placeholder="-"
                                                               id="payment_amount" type="number"
                                                               value="<?php echo e($step['payment_amount']); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-3" style="display:none">
                                                    <div class="primary_input mb-35">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(_trans('installment.Amount Type')); ?> <span
                                                                class="text-danger"> *</span></label>

                                                        <select
                                                            class="primary_select payment_step_payment_type payment_steps"
                                                            name="payment_steps[<?php echo e($key); ?>][amount_type]">
                                                            <option
                                                                data-display="<?php echo e(_trans('installment.Amount Type')); ?>"
                                                                value=""><?php echo e(_trans('installment.Amount Type')); ?> </option>
                                                            <option value="fixed_amount">
                                                                <?php echo e(_trans('installment.Fixed Amount')); ?> </option>
                                                            <option value="percent" selected>
                                                                <?php echo e(_trans('installment.Percent')); ?> </option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2" style="margin-top: 35px;">
                                                    <button type="button"
                                                            class="primary-btn icon-only fix-gr-bg removePaymentStep"><span
                                                            class="ti-trash"></span></button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php elseif(isset($data['plan'])): ?>
                                        <?php $__currentLoopData = $data['plan']->paymentSteps->where('payment_title', '!=', 'Upfront'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $step): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="row">
                                                <div class="col-lg-6">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex" for="payment_title">
                                                            <?php echo e(_trans('installment.Title')); ?> <span class="text-danger"> *</span></label>
                                                        <input class="primary_input_field payment_steps"
                                                               name="payment_steps[<?php echo e($key); ?>][payment_title]"
                                                               placeholder="-"
                                                               id="payment_title_<?php echo e($key); ?>" type="text"
                                                               value="<?php echo e($step->payment_title); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex"
                                                               for="payment_deadline">
                                                            <?php echo e(_trans('installment.Deadline')); ?>

                                                            (<?php echo e(_trans('installment.Days')); ?>) <span class="text-danger"> *</span></label>
                                                        <input class="primary_input_field payment_steps"
                                                               name="payment_steps[<?php echo e($key); ?>][payment_deadline]"
                                                               placeholder="-"
                                                               id="payment_deadline" type="number"
                                                               value="<?php echo e($step->payment_deadline); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2">
                                                    <div class="primary_input mb-25">
                                                        <label class="primary_input_label d-flex" for="payment_amount">
                                                            <?php echo e(_trans('installment.Amount')); ?>

                                                            (<?php echo e(_trans('installment.Percent')); ?>) <span
                                                                class="text-danger"> *</span></label>
                                                        <input class="primary_input_field payment_steps step_amount"
                                                               name="payment_steps[<?php echo e($key); ?>][payment_amount]"
                                                               placeholder="-"
                                                               id="payment_amount" type="number"
                                                               value="<?php echo e($step->payment_amount); ?>">
                                                    </div>
                                                </div>
                                                <div class="col-lg-3" style="display:none">
                                                    <div class="primary_input mb-35">
                                                        <label class="primary_input_label"
                                                               for=""><?php echo e(_trans('installment.Amount Type')); ?> <span
                                                                class="text-danger"> *</span></label>

                                                        <select
                                                            class="primary_select payment_step_payment_type payment_steps"
                                                            name="payment_steps[<?php echo e($key); ?>][amount_type]">
                                                            <option
                                                                data-display="<?php echo e(_trans('installment.Amount Type')); ?>"
                                                                value=""><?php echo e(_trans('installment.Amount Type')); ?> </option>
                                                            <option value="fixed_amount">
                                                                <?php echo e(_trans('installment.Fixed Amount')); ?> </option>
                                                            <option value="percent" selected>
                                                                <?php echo e(_trans('installment.Percent')); ?> </option>
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2" style="margin-top: 35px;">
                                                    <button type="button"
                                                            class="primary-btn icon-only fix-gr-bg removePaymentStep"><span
                                                            class="ti-trash"></span></button>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </div>

                                <div class="col-lg-12 text-center pt_15">
                                    <div class="d-flex justify-content-center">
                                        <button class="primary-btn semi_large2  fix-gr-bg" id="save_plan_button"
                                                type="submit"><i
                                                class="ti-check"></i> <?php echo e(isset($data['plan']) ? __('common.Update') : __('common.Add')); ?> <?php echo e(_trans('installment.Plan')); ?>

                                        </button>
                                    </div>
                                </div>
                            </form>
            </div>
        </div>

    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        (function ($) {
            "use strict";
            $('#add_new_feature').on('click', function (e) {
                e.preventDefault();
                var html = `<div class="row">
                        <div class="col-lg-6" >
                            <div class="primary_input mb-25">
                                <input class="primary_input_field" name="features[]" placeholder="-" id="addCapacity" type="text" value="">
                            </div>
                        </div>
                        <div class="col-lg-4 mt_10">
                            <button type="button" class="primary-btn icon-only fix-gr-bg removePlanFeature"><span class="ti-trash pe-2"></span></button>
                        </div>
                    </div>`;
                $('#feature_list').append(html);
            });
            $('#add_new_step').on('click', function (e) {
                e.preventDefault();
                let index = $('#payment_step_list').children().length + 1;
                let html = `<div class="row">
                            <div class="col-lg-6">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_title"> <?php echo e(_trans('installment.Title')); ?> <span class="text-danger"> *</span></label>
                                    <input class="primary_input_field payment_steps" name="payment_steps[${index}][payment_title]" placeholder="-" id="payment_title_${index}" type="text" value="">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_deadline"> <?php echo e(_trans('installment.Deadline')); ?> (<?php echo e(_trans('installment.Days')); ?>) <span class="text-danger"> *</span></label>
                                    <input class="primary_input_field payment_steps" name="payment_steps[${index}][payment_deadline]" placeholder="-" id="payment_deadline" type="number" value="">
                                </div>
                            </div>
                            <div class="col-lg-2">
                                <div class="primary_input mb-25">
                                    <label class="primary_input_label d-flex" for="payment_amount"> <?php echo e(_trans('installment.Amount')); ?> (<?php echo e(_trans('installment.Percent')); ?>) <span class="text-danger"> *</span></label>
                                    <input class="primary_input_field payment_steps step_amount" name="payment_steps[${index}][payment_amount]" placeholder="-" id="payment_amount" type="number" value="">
                                </div>
                            </div>
                            <div class="col-lg-3" style="display:none">
                                <div class="primary_input mb-35">
                                    <label class="primary_input_label" for=""><?php echo e(_trans('installment.Amount Type')); ?> <span class="text-danger"> *</span></label>

                                    <select class="primary_select payment_step_payment_type payment_steps" name="payment_steps[${index}][amount_type]">
                                        <option data-display="<?php echo e(_trans('installment.Amount Type')); ?>"
                                            value=""><?php echo e(_trans('installment.Amount Type')); ?> </option>
                                            <option value="fixed_amount"><?php echo e(_trans('installment.Fixed Amount')); ?> </option>
                                            <option value="percent" selected ><?php echo e(_trans('installment.Percent')); ?> </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-lg-2" style="margin-top: 35px;">
                                <button type="button" class="primary-btn icon-only fix-gr-bg removePaymentStep"><span class="ti-trash"></span></button>
                            </div>
                        </div>`;

                $('#payment_step_list').append(html);
                let notLastElement = $('#payment_step_list').children().not(':last');
                notLastElement.find('.payment_step_payment_type').niceSelect('update');

                $('#payment_step_list').children().last().find('.payment_step_payment_type').niceSelect();
            });

            $(document).on('click', '.removePlanFeature', function (e) {
                e.preventDefault();
                $(this).parent().parent().remove();
            });
            $(document).on('click', '.removePaymentStep', function (e) {
                e.preventDefault();
                $(this).parent().parent().remove();
            });

            function planVerification(el) {
                if ($(el).prop('checked') == true) {
                    $('.varification_section').fadeIn();
                } else {
                    $('.varification_section').fadeOut();
                }
            }

            function handleTargetType() {
                $('#target_item_options').html('');
                if ($(this).val() == 'course') {
                    $('#target_item_options').append(`
                        <option data-display="<?php echo e(_trans('installment.Select Target')); ?>" value=""><?php echo e(_trans('installment.Select Target')); ?> </option>
                        <option value="all_course" <?php echo e(isset($selected_target) ? ($selected_target == 'all_course' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.All Course')); ?> </option>
                        <option value="specific_category" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_category' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Category')); ?> </option>
                        <option value="specific_instructor" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_instructor' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Instructor')); ?> </option>
                        <option value="specific_course" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_course' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Course')); ?> </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'quiz') {
                    $('#target_item_options').append(`
                        <option data-display="<?php echo e(_trans('installment.Select Target')); ?>" value=""><?php echo e(_trans('installment.Select Target')); ?> </option>
                        <option value="all_quiz" <?php echo e(isset($selected_target) ? ($selected_target == 'all_quiz' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.All Quiz')); ?> </option>
                        <option value="specific_instructor" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_instructor' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Instructor')); ?> </option>
                        <option value="specific_quiz" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_quiz' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Quiz')); ?> </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'live_class') {
                    $('#target_item_options').append(`
                        <option data-display="<?php echo e(_trans('installment.Select Target')); ?>" value=""><?php echo e(_trans('installment.Select Target')); ?> </option>
                        <option value="all_live_class" <?php echo e(isset($selected_target) ? ($selected_target == 'all_live_class' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.All Live Class')); ?> </option>
                        <option value="specific_instructor" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_instructor' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Instructor')); ?> </option>
                        <option value="specific_class" <?php echo e(isset($selected_target) ? ($selected_target == 'specific_class' ? 'selected' : '') : ''); ?>><?php echo e(_trans('installment.Specific Class')); ?> </option>
                    `);
                    $('#target_item_options').niceSelect('update');
                }

                if ($(this).val() == 'all') {
                    $('#target_options').fadeOut();
                } else {
                    $('#target_options').fadeIn();
                }
                $('#specific_section').fadeOut();
            }

            function handleTarget() {
                let selected_value = $(this).val();
                let specific_item_select = $('#specific_item_select');
                let specic_item_lebel = $('#specic_item_lebel');
                if (selected_value == 'specific_category') {
                    specific_item_select.html('');
                    <?php $__currentLoopData = $data['categories']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    specific_item_select.append(`
                            <option value="<?php echo e($category->id); ?>" <?php echo e(in_array($category->id, $target_item) ? 'selected' : ''); ?>><?php echo e($category->name); ?></option>
                        `);
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    specic_item_lebel.html(`<?php echo e(_trans('installment.Select Category')); ?>`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_category[]');
                }

                if (selected_value == 'specific_instructor') {
                    specific_item_select.html('');
                    <?php $__currentLoopData = $data['instructors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    specific_item_select.append(`
                            <option value="<?php echo e($instructor->id); ?>" <?php echo e(in_array($instructor->id, $target_item) ? 'selected' : ''); ?> ><?php echo e($instructor->name); ?></option>
                        `);
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    specic_item_lebel.html(`<?php echo e(_trans('installment.Select Instructor')); ?>`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_instructor[]');

                }
                if (selected_value == 'specific_course') {
                    specific_item_select.html('');
                    <?php $__currentLoopData = $data['courses']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    specific_item_select.append(`
                            <option value="<?php echo e($course->id); ?>" <?php echo e(in_array($course->id, $target_item) ? 'selected' : ''); ?>><?php echo e($course->getTranslation('title', auth()->user()->language_code)); ?></option>
                        `);
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    specic_item_lebel.html(`<?php echo e(_trans('installment.Select Course')); ?>`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_course[]');
                }
                if (selected_value == 'specific_quiz') {
                    specific_item_select.html('');
                    <?php $__currentLoopData = $data['quizzes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quiz): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    specific_item_select.append(`
                            <option value="<?php echo e($quiz->id); ?>" <?php echo e(in_array($quiz->id, $target_item) ? 'selected' : ''); ?>><?php echo e($quiz->title); ?></option>
                        `);
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    specic_item_lebel.html(`<?php echo e(_trans('installment.Select Quiz')); ?>`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_quiz[]');

                }
                if (selected_value == 'specific_class') {
                    specific_item_select.html('');
                    <?php $__currentLoopData = $data['live_classes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $live_class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    specific_item_select.append(`
                            <option value="<?php echo e($live_class->id); ?>" <?php echo e(in_array($live_class->id, $target_item) ? 'selected' : ''); ?>><?php echo e($live_class->title); ?></option>
                        `);
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    specic_item_lebel.html(`<?php echo e(_trans('installment.Select Live Class')); ?>`);
                    $('#specific_section').fadeIn();
                    specific_item_select.attr('name', 'specific_class[]');
                }
                if (selected_value == 'all_course' || selected_value == 'all_quiz' || selected_value == 'all_live_class') {
                    $('#specific_section').fadeOut();
                }
                $('select[multiple]').multiselect('reload');
            }

            function checkFeatureValue() {
                let features = $('input[name="features[]"]');
                let process = true;
                features.each(function () {
                    if ($(this).val().trim() == '') {
                        process = false;
                        $(this).css('border', '1px solid red');
                        toastr.error('Please fill all the feature value', 'Error');
                        return false
                    } else {
                        $(this).css('border', '1px solid #eceef4');
                    }
                });
                return process;
            }

            function paymentStepsValue() {
                let payment_steps = $('.payment_steps');
                let process = true;
                payment_steps.each(function (index, value) {
                    if (value != '[object HTMLDivElement]') {
                        var element_value = $(this).val().trim();
                        if (element_value == '') {
                            process = false;
                            $(this).css('border', '1px solid red');
                            toastr.error('Please fill all the payment steps value', 'Error');
                            return false
                        } else {
                            $('.payment_steps').css('border', '1px solid #eceef4');
                        }

                        if (element_value == 'upfront' || element_value == 'Upfront') {
                            process = false;
                            $(this).css('border', '1px solid red');
                            toastr.error("Don't use upfront as payment step title", "Error");
                            return false
                        } else {
                            $('.payment_steps').css('border', '1px solid #eceef4');
                        }
                    }

                });
                return process;
            }

            function paymentAmountValue() {
                let step_amount = $('.step_amount');
                let process = true;
                let total_percentage = 0;
                step_amount.each(function (index, value) {
                    if (value != '[object HTMLDivElement]') {
                        var element_value = $(this).val().trim();
                        total_percentage += parseInt(element_value);
                        if (total_percentage > 100) {
                            process = false;
                            $('.step_amount').css('border', '1px solid red');
                            toastr.error('Total percentage must be 100', 'Error');
                            return false
                        } else {
                            $('.step_amount').css('border', '1px solid #eceef4');
                        }
                    }
                });
                return process;
            }

            $('#save_plan_button').on('click', function (e) {
                e.preventDefault();
                var feature_status = checkFeatureValue();
                var payment_steps_status = paymentStepsValue();
                var payment_amount_status = paymentAmountValue();

                if (!feature_status) {
                    e.preventDefault();
                    return false;
                } else if (!payment_steps_status) {
                    e.preventDefault();
                    return false;
                } else if (!payment_amount_status) {
                    e.preventDefault();
                    return false;
                } else {
                    $("#plan_save_form").submit();
                }
            });

            $('#select_target_type').on('change', handleTargetType);
            $('#target_item_options').on('change', handleTarget);
            $(document).ready(function () {

                $('#select_target_type').trigger('change');
                $('#target_item_options').trigger('change');

                planVerification($('#checkbox_varification'));
            });

        })(jQuery);

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Installment/Resources/views/plan/create.blade.php ENDPATH**/ ?>