<?php $__env->startSection('mainContent'); ?>

    <?php echo generateBreadcrumb(); ?>

    <div class="row justify-content-center">
        <div class="col-12">
            <div class="box_header common_table_header">
                <div class="main-title d-md-flex">
                    <h3 class="mb-0 mr-30 mb_xs_15px mb_sm_20px"><?php echo e(__('setting.Color Theme')); ?></h3>

                    <ul class="d-flex">
                        <li><a class="primary-btn radius_30px   fix-gr-bg"
                               href="<?php echo e(route('appearance.themes-customize.index')); ?>"><i
                                    class="ti-list"></i><?php echo e(__('setting.Color Theme List')); ?></a>
                        </li>
                    </ul>

                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="white-box">
                <form method="POST" action="<?php echo e(route('appearance.themes-customize.store')); ?>" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="row form">
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label" for="title"><?php echo e(__('setting.Theme Title')); ?> *</label>
                                <input type="text" name="title" class="primary_input_field" id="title" required
                                       maxlength="191" autofocus value="<?php echo e(old('title')); ?>">
                                <span class="text-danger"><?php echo e($errors->first('title')); ?></span>
                            </div>
                        </div>

                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input">
                                <label class="primary_input_label" for=""><?php echo e(__('setting.Themes')); ?> *</label>
                                <select class="primary_select mb-15 theme" name="theme" id="theme">
                                    <?php $__currentLoopData = $themes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $theme): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option
                                            value="<?php echo e($theme->name); ?>"><?php echo e($theme->title); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <span class="text-danger"><?php echo e($errors->first('theme')); ?></span>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <label class="primary_input_label" for=""><?php echo e(__('frontend.Gradient Color')); ?> *</label>
                            <select class="primary_select mb-15 theme" name="is_gradient" id="is_gradient">
                                <option value="1"><?php echo e(__('common.Yes')); ?></option>
                                <option value="0"><?php echo e(__('common.No')); ?></option>
                            </select>

                        </div>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Primary Color')); ?></label>
                                <input type="color" name="p_color"
                                       class="primary_input_field color_field" value="<?php echo e($default->primary_color); ?>"
                                       required
                                >
                                <span class="text-danger"><?php echo e($errors->first('p_color')); ?></span>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6" id="gradient_color">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Primary Color')); ?>(2)</label>
                                <input type="color" name="g_color" value="<?php echo e($default->gradient_color); ?>"
                                       class="primary_input_field color_field"
                                       required
                                >
                                <span class="text-danger"><?php echo e($errors->first('g_color')); ?></span>
                            </div>
                        </div>

                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Secondary Color')); ?></label>
                                <input type="color" name="s_color"
                                       class="primary_input_field color_field" value="<?php echo e($default->secondary_color); ?>"
                                       required>
                                <span class="text-danger"><?php echo e($errors->first('s_color')); ?></span>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <hr>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Footer Background Color')); ?></label>
                                <input type="color" name="footer_background_color"
                                       value="<?php echo e($default->footer_background_color); ?>"
                                       class="primary_input_field color_field"
                                       required>
                                <span class="text-danger"><?php echo e($errors->first('footer_background_color')); ?></span>
                            </div>
                        </div>

                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Footer Headline Color')); ?></label>
                                <input type="color" name="footer_headline_color"
                                       value="<?php echo e($default->footer_headline_color); ?>"
                                       class="primary_input_field color_field"
                                       required>
                                <span class="text-danger"><?php echo e($errors->first('footer_headline_color')); ?></span>
                            </div>
                        </div>


                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Footer Text Color')); ?></label>
                                <input type="color" name="footer_text_color" value="<?php echo e($default->footer_text_color); ?>"
                                       class="primary_input_field color_field"
                                       required>
                                <span class="text-danger"><?php echo e($errors->first('footer_text_color')); ?></span>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Footer Text Hover Color')); ?></label>
                                <input type="color" name="footer_text_hover_color"
                                       class="primary_input_field color_field"
                                       required>
                                <span class="text-danger"><?php echo e($errors->first('footer_text_hover_color')); ?></span>
                            </div>
                        </div>
                        <div class="col-xxl-3 col-xl-3 col-md-4 col-sm-6">
                            <div class="primary_input mb-15">
                                <label class="primary_input_label"
                                       for=" "><?php echo e(__('setting.Background Color')); ?></label>
                                <input type="color" name="bg_color"
                                       class="primary_input_field color_field"
                                       value="#ffffff"
                                       required>
                                <span class="text-danger"><?php echo e($errors->first('bg_color')); ?></span>
                            </div>
                        </div>
                    </div>


                    <div class="row form">
                        <div class="col-12">
                            <div class="primary_input mb-25">
                                <label class="primary_checkbox d-flex mr-12 w-100">
                                    <input name="is_default" value="1"
                                           type="checkbox" <?php echo e(old('is_default') ? 'checked' : ''); ?> >
                                    <span class="checkmark"></span>
                                    <p class="ms-2"><?php echo e(__('setting.Make Default Theme')); ?>  </p>
                                </label>
                            </div>
                        </div>

                        <div class="col-12">
                            <div class="submit_btn text-center d-flex flex-wrap gap-3">

                                <button class="primary-btn semi_large2 fix-gr-bg" type="submit"><i
                                        class="ti-check"></i><?php echo e(__('common.Save')); ?>

                                </button>

                                <button class="primary-btn semi_large2 fix-gr-bg" id="reset_to_default" type="button"><i
                                        class="ti-reload"></i><?php echo e(__('setting.Reset To Default')); ?>

                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
    <script>
        //document on ready function
        $(document).ready(function () {
            $('#is_gradient').trigger('change');
        })
        $(document).on('click', '#reset_to_default', function () {
            document.location.reload(true);
        });
        $(document).on('change', '#is_gradient', function () {
            if ($(this).val() == 1) {
                $('#gradient_color').removeClass('d-none');
            } else {
                $('#gradient_color').addClass('d-none');
            }
        });
    </script>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('backend.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/minialms/card.minialms.com/Modules/Appearance/Resources/views/customize/create.blade.php ENDPATH**/ ?>