<div class="modal-dialog modal-lg modal-dialog-centered student-details">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">
                <?php if($edit): ?>
                    <?php echo e(__('common.Edit')); ?>

                <?php else: ?>
                    <?php echo e(__('common.Add')); ?>

                <?php endif; ?>
                <?php echo e(__('assignment.Assignment')); ?>

            </h4>
            <button type="button" class="btn-close" data-bs-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
            <form
                <?php if(isset($edit)): ?>
                action="<?php echo e(route('course_assignment_update')); ?>" method="POST" id="coupon-form" name="coupon-form"
                enctype="multipart/form-data">
                <input type="hidden" name="id" value="<?php echo e($edit->assignmentInfo->id); ?>">
                <?php else: ?>
                    action="<?php echo e(route('course_assignment_store')); ?>"
                    method="POST"
                    name="coupon-form" enctype="multipart/form-data">
                <?php endif; ?>
                <?php echo csrf_field(); ?>
                <input type="hidden" name="course_id" value="<?php echo e($course_id); ?>">
                <input type="hidden" name="chapter_id" value="<?php echo e($chapter_id); ?>">
                <input type="hidden" name="lesson_id" value="<?php echo e(isset($edit)?$edit->id:0); ?>">
                <input type="hidden" name="assignment_from" value="2">


                <div class="row">

                    
                    <div class="col-xl-12">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label"
                                   for="title"><?php echo e(__('common.Title')); ?> <strong
                                    class="text-danger">*</strong></label>
                            <input name="title" id="title"
                                   class="primary_input_field name <?php echo e(@$errors->has('title') ? ' is-invalid' : ''); ?>"
                                   placeholder="<?php echo e(__('common.Title')); ?>"
                                   type="text"
                                   value="<?php echo e(isset($edit)?$edit->assignmentInfo->title:old('title')); ?>" <?php echo e($errors->has('title') ? 'autofocus' : ''); ?>>
                            <?php if($errors->has('title')): ?>
                                <span class="invalid-feedback d-block mb-10" role="alert">
                                                                            <strong><?php echo e(@$errors->first('title')); ?></strong>
                                                                        </span>
                            <?php endif; ?>
                        </div>
                    </div>

                </div>
                <div class="row">

                    
                    <div class="col-xl-6">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label"
                                   for="number"><?php echo e(__('assignment.Marks')); ?><strong
                                    class="text-danger">*</strong> </label>
                            <input name="marks"
                                   class="primary_input_field name <?php echo e(@$errors->has('marks') ? ' is-invalid' : ''); ?>"
                                   placeholder="<?php echo e(__('assignment.Marks')); ?>"
                                   type="text" id="number" min="0" step="any"
                                   <?php echo e($errors->has('marks') ? 'autofocus' : ''); ?>

                                   value="<?php echo e(isset($edit)?$edit->assignmentInfo->marks:old('marks')); ?>">
                            <?php if($errors->has('marks')): ?>
                                <span class="invalid-feedback d-block mb-10" role="alert">
                                                                        <strong><?php echo e(@$errors->first('marks')); ?></strong>
                                                                    </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    
                    <div class="col-xl-6">
                        <div class="primary_input mb-25">
                            <label class="primary_input_label"
                                   for="number2"><?php echo e(__('assignment.Min Percentage')); ?>

                                <strong
                                    class="text-danger">*</strong></label>
                            <input name="min_parcentage"
                                   <?php echo e($errors->has('min_parcentage') ? 'autofocus' : ''); ?>

                                   class="primary_input_field name <?php echo e(@$errors->has('code') ? ' is-invalid' : ''); ?>"
                                   placeholder="<?php echo e(__('assignment.Min Percentage')); ?>"
                                   type="number" id="number2" min="0" step="any"
                                   value="<?php echo e(isset($edit)?$edit->assignmentInfo->min_parcentage:old('min_parcentage')); ?>">
                            <?php if($errors->has('min_parcentage')): ?>
                                <span class="invalid-feedback d-block mb-10" role="alert">
                                                                        <strong><?php echo e(@$errors->first('min_parcentage')); ?></strong>
                                                                    </span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-xl-6">
                        <div class=" mb-35">
                            <?php if (isset($component)) { $__componentOriginal3c189c37dfafa3e6853f94906c245d36 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal3c189c37dfafa3e6853f94906c245d36 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.upload-file','data' => ['name' => 'attachment','mediaId' => ''.e(isset($edit)?$edit->assignmentInfo->attachment_media?->media_id:'').'','label' => ''.e(__('assignment.Attachment')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('upload-file'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'attachment','media_id' => ''.e(isset($edit)?$edit->assignmentInfo->attachment_media?->media_id:'').'','label' => ''.e(__('assignment.Attachment')).'']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $attributes = $__attributesOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__attributesOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal3c189c37dfafa3e6853f94906c245d36)): ?>
<?php $component = $__componentOriginal3c189c37dfafa3e6853f94906c245d36; ?>
<?php unset($__componentOriginal3c189c37dfafa3e6853f94906c245d36); ?>
<?php endif; ?>

                            <?php if(isset($edit) && file_exists($edit->assignmentInfo->attachment)): ?>
                                 <a href="<?php echo e(asset(@$edit->assignmentInfo->attachment)); ?>" class="primary-btn small fix-gr-bg text-nowrap text-white btn-fit"
                                     download="<?php echo e(@$edit->assignmentInfo->title); ?>_attachment"><?php echo e(__('common.Download')); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-xl-6">
                        <div class="primary_input mb-15">
                            <label class="primary_input_label"
                                   for="start_date"><?php echo e(__('assignment.Submit Date')); ?></label>
                            <div class="primary_datepicker_input">
                                <div class="g-0  input-right-icon">
                                    <div class="col">
                                        <div class="">
                                            <input placeholder="<?php echo e(__('assignment.Submit Date')); ?>"
                                                   class="primary_input_field primary-input date form-control  <?php echo e(@$errors->has('last_date_submission') ? ' is-invalid' : ''); ?>"
                                                   id="start_date" type="text"
                                                   name="last_date_submission"
                                                   value="<?php echo e(isset($edit)?  date('m/d/Y', strtotime(@$edit->assignmentInfo->last_date_submission)) : date('m/d/Y')); ?>"
                                                   autocomplete="off" required>
                                        </div>
                                    </div>
                                    <button class="" type="button">
                                        <i class="ti-calendar"></i>
                                    </button>
                                </div>
                                <?php if($errors->has('start_date')): ?>
                                    <span class="invalid-feedback d-block mb-10"
                                          role="alert">
                                                            <strong><?php echo e(@$errors->first('start_date')); ?></strong>
                                                            </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row">

                     <div class="col-lg-12">
                        <div class="input-effect">
                            <label class="primary_input_label"> <?php echo e(__('assignment.Description')); ?>

                                <strong
                                    class="text-danger">*</strong>
                            </label>
                            <textarea
                                class="primary_textarea <?php echo e(@$errors->has('description') ? ' is-invalid' : ''); ?>"
                                cols="30" rows="10"
                                name="description"><?php echo e(isset($edit)? $edit->assignmentInfo->description:(old('description')!=''?(old('description')):'')); ?></textarea>

                            <span class="focus-border textarea"></span>
                            <?php if($errors->has('description')): ?>
                                <span
                                    class="error text-danger"><strong><?php echo e($errors->first('description')); ?></strong></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="input-effect mt-2 pt-1">
                            <div class="" id="">
                                <label class="primary_input_label mt-1"
                                       for=""><?php echo e(__('courses.Privacy')); ?>

                                    <span class="required_mark">*</span>
                                <select class="primary_select" name="is_lock">
                                    <option
                                        data-display="<?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Privacy')); ?> "
                                        value=""><?php echo e(__('common.Select')); ?> <?php echo e(__('courses.Privacy')); ?> </option>
                                    <option
                                        value="0" <?php echo e(isset($edit) && $edit->is_lock!=1?'selected':''); ?>>
                                        <?php echo e(__('courses.Unlock')); ?>

                                    </option>

                                    <option
                                        value="1" <?php echo e(isset($edit) && $edit->is_lock==1?'selected':''); ?>>
                                        <?php echo e(__('courses.Locked')); ?>

                                    </option>


                                </select>
                                <?php if($errors->has('is_lock')): ?>
                                    <span class="invalid-feedback invalid-select"
                                          role="alert">
                                                                        <strong><?php echo e($errors->first('is_lock')); ?></strong>
                                                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>


                <div class=" d-flex justify-content-between mt-3">
                    <button type="button" class="primary-btn tr-bg"
                            data-bs-dismiss="modal"><?php echo app('translator')->get('common.Cancel'); ?></button>

                    <button class="primary-btn fix-gr-bg"
                            type="submit">
                        <i class="ti-check"></i>
                        <?php echo app('translator')->get('common.Submit'); ?></button>
                </div>
            </form>

        </div>
    </div>

</div>
<?php echo $__env->make('backend.partials/media_script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<script>
    $(document).ready(function () {
        $('select').niceSelect();

    })
    $('.primary-input.date').datepicker({
        autoclose: true,
        setDate: new Date()
    });
</script>
<?php /**PATH /home/minialms/card.minialms.com/Modules/CourseSetting/Providers/../Resources/views/parts_of_course_details/modal/_assignment.blade.php ENDPATH**/ ?>